# FIXME on x86_64
#warning: Installed (but unpackaged) file(s) found:
#    /usr/lib/libclip-codb.so
#    /usr/lib/libclip.so
#    /usr/lib64/clip/cliprc/.notrm
%define FCLIPDIR %_libdir/clip
%define VCLIPDIR %_localstatedir/clip

Name: clip
Version: 1.2.0cvs
Release: alt6

Summary: XBASE/Clipper compatible program compiler
Summary(ru_RU.UTF-8): Совместимый с XBASE/Clipper компилятор программ

License: GPL-2.0+
Group: Development/Other
Url: http://www.itk.ru

ExcludeArch: aarch64 armh

Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %name-%version.tar.bz2
Patch1: clip-1.2.0-alt-io.patch
Patch2: clip-alt-gcc-10.patch

%add_findreq_skiplist %FCLIPDIR/bin/tconv
#set_verify_elf_method textrel=relaxed
%add_findprov_lib_path %FCLIPDIR/lib

BuildRequires: cvs flex imake libgpm-devel libncurses-devel libreadline-devel libXmu-devel openssh-clients wget xorg-cf-files zlib-devel libpth-devel

Requires: lib%name-devel = %version-%release

%description
This package includes the clip compiler and supplimentary libraries

%description -l ru_RU.UTF-8
Данный пакет содержит компилятор clip и необходимые библиотеки

%package -n lib%name
Summary: XBASE/Clipper compatible program compiler - runtime library
Summary(ru_RU.UTF-8): Совместимый с XBASE/Clipper компилятор программ -- библиотеки времени выполнения
Group: Development/Other

%description -n lib%name
This package provides runtime shared libraries for CLIP package

%description -n lib%name -l ru_RU.UTF-8
Данный пакет предоставляет заголовочные файлы для CLIP

%package -n lib%name-devel
Summary: XBASE/Clipper compatible program compiler - headers
Summary(ru_RU.UTF-8): Совместимый с XBASE/Clipper компилятор программ -- заголовочные файлы
Group: Development/Other
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package provides headers files for CLIP package

%description -n lib%name-devel -l ru_RU.UTF-8
Данный пакет предоставляет заголовочные файлы для CLIP

%prep
%setup -q
%patch1 -p1
%patch2 -p2
# update timestamps of sources after patch apply
touch *.c

%build
export OPTFLAGS="%optflags_shared -std=gnu89"
CLIPROOT=%_libdir/clip BINDIR=%_bindir ./configure -s -stack || exit 1
export CLIPROOT=%buildroot%_libdir/clip
export CLIP_LOCALE_ROOT=`pwd`
# TODO: fix SMP build
%make_build || %make

%install
%makeinstall_std BINDIR=%_bindir CLIPROOT=%_libdir/clip

echo "-v0
-O
-r
-l" > %buildroot%FCLIPDIR/cliprc/clipflags

rm -f %buildroot%_libdir/libclip*

# move locale from read only usr dir to /var/lib
mkdir -p %buildroot%VCLIPDIR
mv %buildroot%FCLIPDIR/locale* %buildroot%VCLIPDIR
ln -s %VCLIPDIR/locale.pot %buildroot%FCLIPDIR/
ln -s %VCLIPDIR/locale.po %buildroot%FCLIPDIR/
ln -s %VCLIPDIR/locale.mo %buildroot%FCLIPDIR/
mv %buildroot%FCLIPDIR/etc %buildroot%VCLIPDIR
ln -s %VCLIPDIR/etc %buildroot%FCLIPDIR/

mkdir -p %buildroot%_sysconfdir/ld.so.conf.d
echo "%FCLIPDIR/lib" >%buildroot%_sysconfdir/ld.so.conf.d/%name.conf
rm -f %buildroot%_bindir/*

# remove unneeded broken symlink
rm -f %buildroot%_libdir/*.so
# don't pack static
rm -f %buildroot%FCLIPDIR/lib/*.a

# FIXME: _libdir using
rm -f %buildroot/usr/lib/*.so
rm -f %buildroot/usr/lib/*.a

rm -f %buildroot%_libdir/clip/cliprc/.notrm

%pre -n lib%name
/usr/sbin/groupadd -r -f %name || :

%triggerpostun -- %name <= 1.1.10-alt2
subst "s,%FCLIPDIR/lib,," /etc/ld.so.conf

%files
%FCLIPDIR/bin/

%files -n lib%name
%dir %FCLIPDIR
%dir %FCLIPDIR/lib
%_sysconfdir/ld.so.conf.d/%name.conf
%FCLIPDIR/lib/lib*.so

%FCLIPDIR/locale.pot
%FCLIPDIR/locale.po
%FCLIPDIR/locale.mo
%dir %VCLIPDIR/locale.pot
%dir %VCLIPDIR/locale.po
%VCLIPDIR/locale.po/*
%dir %VCLIPDIR/locale.mo
%VCLIPDIR/locale.mo/*

%dir %FCLIPDIR/cliprc
%config %FCLIPDIR/cliprc/*
%FCLIPDIR/charsets
%dir %FCLIPDIR/etc
%VCLIPDIR/etc
%FCLIPDIR/keymaps
%FCLIPDIR/lang
%FCLIPDIR/term

%files -n lib%name-devel
%FCLIPDIR/include/

%changelog
