Name: clearsilver
Version: 0.10.5
Release: alt1.3

Summary: Neotonic ClearSilver
License: Open Source - Neotonic ClearSilver License (Apache 1.1 based)
Group: Development/Other
Url: http://www.clearsilver.net/
Packager: Ilya Mashkin <oddity@altlinux.ru>

Source: http://www.clearsilver.net/downloads/%name.tar

BuildPreReq: zlib-devel
BuildPreReq: python-devel >= %__python_version

%def_disable static
#set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1

BuildRequires: rpm-build-python python-modules-encodings zlib-devel

%description
ClearSilver is a fast, powerful, and language-neutral HTML template system.
In both static content sites and dynamic HTML applications, it provides a
separation between presentation code and application logic which makes
working with your project easier.

Because it's written as a C-library, and exported to scripting languages
like Python and Perl via modules, it is extremely fast compared to template
systems written in a script language.

%if_enabled static
%package -n lib%name-devel-static
Summary: Neotonic ClearSilver development files
Group: Development/Python

%description -n lib%name-devel-static
This package contains Neotonic ClearSilver development files.
%endif

%package -n python-module-%name
Summary: Neotonic ClearSilver Python Module
Group: Development/Python
#Requires: %name = %version-%release
Provides: python%__python_version(neo_cgi)
Provides: python%__python_version(neo_cs)
Provides: python%__python_version(neo_util)
Provides: %name-python
Obsoletes: %name-python

%description -n python-module-%name
The clearsilver-python package provides a python interface to the
clearsilver CGI kit and templating system.

%prep
%setup -q -n %name
sed -i 's/LIBRARIES = inserted + LIBRARIES/LIBRARIES = LIBRARIES + inserted/' \
	python/setup.py
# Set correct python2 executable in shebang
subst 's|#!.*python$|#!%__python|' $(grep -Rl '#!.*python$' *)

%build
#__subst 's,python_versions=".*",python_versions="%__python_version",' configure.in
#__autoconf
%configure \
	--disable-wdb \
	--disable-apache \
	--disable-ruby \
	--disable-perl \
	--disable-java \
	--disable-csharp \
	--enable-gettext \
	--enable-python \
	--with-python=%__python \
	%{subst_enable static}

%add_optflags %optflags_shared
%make_build OPT='%optflags'
#__subst "s,/bin/env python,%_bindir/python%__python_version," scripts/document.py

%install
mkdir -p %buildroot{%python_sitelibdir,%_docdir/%name-%version}
%makeinstall PYTHON_SITE=%buildroot%python_sitelibdir install

%if_disabled static
rm -rf %buildroot{%_libdir/*.a,%_includedir/*,%_man3dir/*}
%endif

%files
%_bindir/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%_includedir/*
%_man3dir/*
%endif

%files -n python-module-%name
%python_sitelibdir/neo_cgi.so

%changelog
