%define srcName clean

Name: clean
Version: 3.1
Release: alt5
Summary: The Clean programming language compiler and environment
Summary(ru_RU.UTF-8): Компилятор и системная библиотека для языка Clean
License: BSD license
Group: Development/Functional
Url: https://clean.cs.ru.nl/
ExclusiveArch: x86_64
BuildRequires: prelink-tools

# Пакет базируется на сборочных скриптах компилятора, как рекомендовано
# разработчиками Clean (Джоном и Камилом).
#
# Сборочные скрипты можно скачать в
#    https://gitlab.science.ru.nl/clean-and-itasks/clean-build
#
# Исходные каталоги:
#  clean/build - тут лежит bootstrap compiler
#  clean/clean-base - часть сборочных скриптов
#  clean/src - деревья исходных кодов компилятора и базовых библиотек


Packager: %packager

Source: clean-%version.tar
Patch0: %name-3.0-alt-remove-doc-build.patch

%description
This package contains a Clean language compiler and standard
library. This is a bootstrap package for 64-bit intel architecture.

%prep
%setup -q -n %srcName-%version
%patch0 -p2

%build

./clean-base/linux-x64/build.sh clean-base linux x64

# Компилируем стандартную библиотеку - надо спросить Камила
cd target/clean-base/lib/StdEnv/
for f in `ls *.icl`; do
  PATH=$PATH:../../bin/ CLEANLIB=../exe clm -dynamics -I . -PO `echo $f | sed s/.icl//`
done
PATH=$PATH:../../bin/ CLEANLIB=../exe clm -dynamics -I . -PO StdEnv
cd ../../../../

# Снимаем бит exec stack - разработчик John van Groningen
# сообщил, что его можно снять, и как это сделать.
execstack -c target/clean-base/lib/exe/cg
execstack -c target/clean-base/lib/exe/cocl

# Предупреждения насчёт relocations, к сожалению - положительные
# срабатывания. Цитата из письма Джона:
#
# On my system it doesn't like R_X86_64_NONE relocations. You can verify
# if this is the case with objdump --reloc of the object file (or eu-objdump).
# These relocations are generated by the Clean compiler and are essential.
#
# На ALT Linux это тоже R_X86_64_NONE.

# Перекомпилируем clm с прописанными путями после установки.
# После миграции на системный ld мы должны использовать clms.
cd src/clm-master
make -fMakefile.linux64 CLEANLIB=%_libdir/%name/exe/ CLEANPATH=.:%_libdir/%name/StdEnv/ clms
cp clms ../../target/clean-base/bin/clm

%install
%define docdir %_docdir/%name-%version
mkdir -p %buildroot%_bindir
mkdir -p %buildroot%_libdir/%name
mkdir -p %buildroot%docdir
mkdir -p %buildroot%_mandir

%define target target/clean-base/

install -pm755 %target/bin/* %buildroot/%_bindir/
cp -R %target/lib/* %buildroot%_libdir/%name
cp src/language-report-master/CleanRep.3.0.doc %buildroot%docdir
cp src/language-report-master/todo.txt %buildroot%docdir
cp src/clean-ide-master/CleanLicenseConditions.txt %buildroot%docdir
cp clean-base/linux-x64/txt/README %buildroot%docdir/README.md

# Это костыль, его нужно убрать - я отправил письмо Камиллу,
# что man страница не устанавливается в target.
install -pm644 src/clm-master/clm.1 %buildroot%_mandir

%find_lang %name

%post
# Touching compiled files to prevent autogeneration
touch "/usr/lib64/clean/StdEnv/Clean System Files"/*.abc
sleep 1
touch "/usr/lib64/clean/StdEnv/Clean System Files"/*.o

%files
%_bindir/*
%_libdir/*
%_mandir/*
%%dir %docdir
%docdir/*

%changelog
