# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%define ver_major 6.4

Name: cinnamon-translations
Version: %ver_major.1
Release: alt1

Summary: Translations for Cinnamon
License: GPL-2.0-or-later
Group: Graphical desktop/GNOME
Url: https://github.com/linuxmint/cinnamon-translations
BuildArch: noarch

Source: %name-%version.tar
Patch: %name-%version-%release.patch

Conflicts: cinnamon < 1.9.1

%description
Translations for Cinnamon

%package -n nemo-translations
Summary: Translations for Nemo
Group: Graphical desktop/GNOME
License: GPL-2.0-or-later

%description -n nemo-translations
Translations for Nemo

%package -n nemo-extensions-translations
Summary: Translations for Nemo extensions
Group: Graphical desktop/GNOME
License: GPL-2.0-or-later

%description -n nemo-extensions-translations
Translations for Nemo extensions

%package -n cinnamon-control-center-translations
Summary: Translations for cinnamon-control-center
Group: Graphical desktop/GNOME
License: GPL-2.0-or-later

%description -n cinnamon-control-center-translations
Translations for cinnamon-control-center

%package -n cinnamon-screensaver-translations
Summary: Translations for cinnamon-screensaver
Group: Graphical desktop/GNOME
License: GPL-2.0-or-later

%description -n cinnamon-screensaver-translations
Translations for cinnamon-screensaver

%package -n cinnamon-session-translations
Summary: Translations for cinnamon-session
Group: Graphical desktop/GNOME
License: GPL-2.0-or-later

%description -n cinnamon-session-translations
Translations for cinnamon-session

%package -n cinnamon-settings-daemon-translations
Summary: Translations for cinnamon-settings-daemon
Group: Graphical desktop/GNOME
License: GPL-2.0-or-later

%description -n cinnamon-settings-daemon-translations
Translations for cinnamon-settings-daemon

%prep
%setup -q -n %name-%version
%patch -p1

%build
%make_build

%install
install -m 0755 -d %{buildroot}%{_datadir}/locale
cp -Rp usr/share/locale/* %{buildroot}%{_datadir}/locale

%find_lang cinnamon
%find_lang nemo
%find_lang nemo-extensions
%find_lang cinnamon-control-center
%find_lang cinnamon-screensaver
%find_lang cinnamon-session
%find_lang cinnamon-settings-daemon

%files -f cinnamon.lang
%doc COPYING

%files -n nemo-translations -f nemo.lang

%files -n nemo-extensions-translations -f nemo-extensions.lang

%files -n cinnamon-control-center-translations -f cinnamon-control-center.lang

%files -n cinnamon-screensaver-translations -f cinnamon-screensaver.lang

%files -n cinnamon-session-translations -f cinnamon-session.lang

%files -n cinnamon-settings-daemon-translations -f cinnamon-settings-daemon.lang

%changelog
