# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%define ver_major 6.4
%define _libexecdirname libexec
%define _libexecdir %_prefix/%_libexecdirname
%define _name cinnamon

Name: %{_name}-session
Version: 6.4.1
Release: alt1

License: GPL-2.0-or-later
Summary: The cinnamon session programs for the Cinnamon GUI desktop environment
Group: Graphical desktop/GNOME
URL: https://github.com/linuxmint/cinnamon-session

Source: %name-%version.tar
Source1: %{_name}.session
Source2: %{_name}2d.session
Source3: %{_name}-wayland.session
Source4: start%{_name}-common
Source5: start%{_name}
Source6: start%{_name}2d
Source7: start%{_name}-wayland
Source8: %{_name}.desktop
Source9: %{_name}2d.desktop
Source10: %{_name}-wayland.desktop
Patch: %name-%version-%release.patch

# From configure.in
%define glib_ver 2.33.4
%define gtk_ver 3.0.0
%define polkit_ver 0.91
%define upower_ver 0.9

%{?_enable_wmsession:Requires(pre): xinitrc}
Requires: dconf libcanberra-gnome libcanberra-gtk3
Requires: altlinux-freedesktop-menu-cinnamon
Requires: gstreamer1.0 dbus-tools-gui
Requires: gnome-filesystem
Requires: cinnamon-settings-daemon
Requires: nemo
Requires: upower polkit-gnome gcr
Requires: %name-translations
Requires: cinnamon-screensaver

%add_python3_req_skip config

BuildRequires(pre): rpm-macros-python3
BuildPreReq: rpm-build-python3
# From configure.in
BuildPreReq: meson
BuildPreReq: intltool >= 0.35.0
BuildPreReq: libgio-devel glib2-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libupower-devel >= %upower_ver
BuildRequires: libpango-devel librsvg-devel libjson-glib-devel
BuildRequires: libX11-devel libXau-devel libXrandr-devel libXrender-devel libXt-devel
BuildRequires: libSM-devel libXext-devel libXtst-devel libXi-devel libXcomposite-devel libGL-devel
BuildRequires: xorg-xtrans-devel
BuildRequires: libcanberra-devel
BuildRequires: libcinnamon-desktop-devel
BuildRequires: xmlto
BuildRequires: libsystemd-devel libpolkit-devel
BuildRequires: libxapps-devel
BuildRequires: libGConf-devel

%description
Cinnamon is a Linux desktop which provides advanced innovative features
and a traditional user experience. The desktop layout is similar to Gnome 2.
The underlying technology is forked from Gnome Shell. The emphasis is put on
making users feel at home and providing them with an easy to use and comfortable
desktop experience.

This package provides the Cinnamon session manager.

%package wayland
Summary: Wayland session for Cinnamon
Group: Graphical desktop/GNOME
BuildArch: noarch
Requires(pre): %{_name} >= %ver_major

%description wayland
Wayland session for Cinnamon.

%prep
%setup -q
%patch -p1

%build
%meson --libexecdir=%_libexecdirname
%meson_build

%install
%meson_install

install -pD -m655 %SOURCE1 %buildroot%_datadir/%name/sessions/%{_name}.session
install -pD -m655 %SOURCE2 %buildroot%_datadir/%name/sessions/%{_name}2d.session
install -pD -m655 %SOURCE3 %buildroot%_datadir/%name/sessions/%{_name}-wayland.session
install -pD -m755 %SOURCE4 %buildroot%_datadir/%name/start%{_name}-common
install -pD -m755 %SOURCE5 %buildroot%_bindir/start%{_name}
install -pD -m755 %SOURCE6 %buildroot%_bindir/start%{_name}2d
install -pD -m755 %SOURCE7 %buildroot%_bindir/start%{_name}-wayland

mkdir -p %buildroot%_datadir/xsessions
install -pD -m655 %SOURCE8 %buildroot%_datadir/xsessions
install -pD -m655 %SOURCE9 %buildroot%_datadir/xsessions

mkdir -p %buildroot%_datadir/wayland-sessions
install -pD -m655 %SOURCE10 %buildroot%_datadir/wayland-sessions

rm -f %buildroot%_docdir/%name/dbus/cinnamon-session.html

%find_lang --with-gnome --output=%name.lang %name-3.0

%files -f %name.lang
%_bindir/*
%_prefix/libexec/cinnamon-session-binary
%_libexecdir/cinnamon-session-check-accelerated
%_libexecdir/cinnamon-session-check-accelerated-helper
%dir %_datadir/%name
%_datadir/%name/*.glade
%_datadir/%name/hardware-compatibility
%_datadir/%name/start%{_name}-common
%dir %_datadir/%name/sessions
%_datadir/%name/sessions/%{_name}.session
%_datadir/%name/sessions/%{_name}2d.session
%_iconsdir/hicolor/*/apps/cinnamon-session-properties.*
%config %_datadir/glib-2.0/schemas/org.cinnamon.SessionManager.gschema.xml
%_mandir/man?/*
%_datadir/%name/cinnamon-session-quit.py
%_datadir/%name/config.py
%_datadir/xsessions/*.desktop
%doc AUTHORS NEWS README

%files wayland
%_datadir/cinnamon-session/sessions/%{_name}-wayland.session
%_datadir/wayland-sessions/%{_name}-wayland.desktop

%changelog
