# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%define ver_major 6.4
%define _libexecdir %_prefix/libexec

Name: cinnamon-screensaver
Version: %ver_major.0
Release: alt1

Summary: Cinnamon Screensaver
License: GPL-2.0-or-later
Group: Graphical desktop/GNOME
Url: https://github.com/linuxmint/cinnamon-screensaver

Provides: screen-saver-engine
Provides: screen-saver-frontend
Provides: cinnamon-screensaver-module

Source: %name-%version.tar
Source1: %name.pam
Patch: %name-%version-%release.patch

BuildPreReq: meson
BuildRequires: python3-dev
BuildRequires: libgio-devel
BuildRequires: libgtk+3-devel
BuildRequires: libgtk+3-gir-devel
BuildRequires: gobject-introspection-devel
BuildRequires: libdbus-glib-devel
BuildRequires: libpam0-devel
BuildRequires: libXinerama-devel
BuildRequires: xdotool-devel
BuildRequires: libXrandr-devel
Requires: %name-translations
Requires: typelib(CDesktopEnums)

Obsoletes: libcinnamon-screensaver <= %EVR
Obsoletes: libcinnamon-screensaver-gir <= %EVR
Obsoletes: libcinnamon-screensaver-devel <= %EVR
Obsoletes: libcinnamon-screensaver-gir-devel <= %EVR

%add_python3_self_prov_path %buildroot%_datadir/%name

%description
cinnamon-screensaver is a screen saver and locker that aims to have
simple, sane, secure defaults and be well integrated with the Cinnamon desktop.

%prep
%setup -q
%patch -p1

%build
export CFLAGS=-DUSE_SETRES
%meson --libexecdir=%_lib
%meson_build

%install
%meson_install

rm -f %buildroot/%_sysconfdir/pam.d/cinnamon-screensaver
install -pm640 %SOURCE1 %buildroot/%_sysconfdir/pam.d/cinnamon-screensaver

# Remove development library
rm -r %buildroot%_datadir/gir-1.0/*.gir

%filter_from_requires /python3[(]dbusdepot[)]/d
%filter_from_requires /python3[(]util[)]/d
%filter_from_requires /python3[(]widgets[)]/d
%filter_from_requires /python3[(]pamhelper[)]/d
%filter_from_requires /python3[(]pamhelper[)]/d
%filter_from_requires /python3[(]gi.repository.CDesktopEnums[)]/d
%filter_from_requires /python3[(]gi.repository.CDesktopEnums[)]/d
%filter_from_requires /typelib[(]CScreensaver[)]/d

%files
%_bindir/cinnamon-screensaver
%_bindir/cinnamon-unlock-desktop
%_libdir/cinnamon-screensaver/
%attr(2711,root,chkpwd) %_libdir/cinnamon-screensaver/cinnamon-screensaver-pam-helper
%attr(640,root,chkpwd) %config(noreplace) %_sysconfdir/pam.d/cinnamon-screensaver
%_bindir/cinnamon-screensaver-command
%_datadir/cinnamon-screensaver/
%_datadir/dbus-1/services/org.cinnamon.ScreenSaver.service
%_datadir/applications/org.cinnamon.ScreenSaver.desktop
%_datadir/icons/hicolor/scalable/*/*.svg
%_datadir/icons/hicolor/scalable/*/*.svg
%doc AUTHORS NEWS README.md

%changelog
