%define _unpackaged_files_terminate_build 1

Name: cgal
Version: 6.0.1
Release: alt1

Summary: Easy access to efficient and reliable geometric algorithms
License: LGPLv3+ and GPLv3+ and Boost
Group: Sciences/Mathematics

Url: https://www.cgal.org/
VCS: https://github.com/CGAL/cgal
# Source0-url: https://github.com/CGAL/cgal/archive/refs/tags/v%version.tar.gz
Source0: CGAL-%version.tar
# Source1-url: https://github.com/CGAL/cgal/releases/download/v%version/CGAL-%version-doc_html.tar.xz
Source1: CGAL-%version-doc_html.tar

BuildRequires(pre): rpm-build-python3
%ifarch %e2k
BuildRequires: gcc-c++
%else
BuildRequires: gcc-c++ >= 8.3
%endif
BuildRequires: cmake >= 3.14
BuildRequires: boost-devel eigen3
BuildRequires: libGLU-devel libGL-devel libmpfr-devel libtbb-devel
BuildRequires: zlib-devel libX11
BuildRequires: liblapack-devel
BuildRequires: qt6-base-devel
BuildRequires: qt6-svg-devel
BuildRequires: qt6-declarative-devel
BuildRequires: qt6-tools-devel

ExcludeArch: armh

%description
The goal of the CGAL Open Source Project is to provide easy access to
efficient and reliable geometric algorithms in the form of a C++
library.

%package devel
Summary: Development files of CGAL
Group: Development/C++
Conflicts: %name < %EVR
Obsoletes: %name < %EVR
Conflicts: lib%name-devel < %EVR
Obsoletes: lib%name-devel < %EVR

%description devel
The goal of the CGAL Open Source Project is to provide easy access to
efficient and reliable geometric algorithms in the form of a C++
library.

This Package contains developemnt files of CGAL.

%package devel-doc
Summary: Documentation for CGAL
Group: Development/Documentation
BuildArch: noarch

%description devel-doc
The goal of the CGAL Open Source Project is to provide easy access to
efficient and reliable geometric algorithms in the form of a C++
library.

Thid package contains development documentation for CGAL.

%prep
%setup -a1

%build
%cmake \
	-DCMAKE_BUILD_TYPE=Release \
	-DCGAL_INSTALL_DOC_DIR=%_defaultdocdir/%name \
	-DWITH_demos:BOOL=false \
	-DWITH_examples:BOOL=false \
	%nil

%cmake_build

%install
%cmake_install
install -d %buildroot%_docdir/%name
cp -fR doc_html %buildroot%_docdir/%name
# due to python2 scripts
rm -rfv %buildroot%_libdir/cmake/CGAL/Help

%files devel
%_bindir/*
%_man1dir/*
%_includedir/*
%_libdir/cmake/CGAL

%files devel-doc
%doc %_docdir/%{name}*

%changelog
