%define _unpackaged_files_terminate_build 1

%define modname ceph-deploy

Name: ceph-deploy
Version: 2.1.0
Release: alt3

Summary: Deploy Ceph with minimal infrastructure
License: MIT
Group: System/Base

Url: https://github.com/ceph/ceph-deploy
BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3

BuildRequires: openssh-clients

BuildRequires: python3-module-remoto >= 1.1.4
BuildRequires: python3-module-sphinx

# Tox tests requirements
#BuildRequires: python3-module-pytest
#BuildRequires: python3-module-mock
#BuildRequires: python3-module-tox

Requires: python3-module-%name = %EVR


%description
ceph-deploy is a way to deploy Ceph relying on just SSH access to the servers, sudo, 
and some Python. It runs fully on your workstation, requiring no servers, databases, 
or anything like that.

%package -n python3-module-%name
Summary: Deploy Ceph with minimal infrastructure
Group: Development/Python3
%py3_requires remoto

%description -n python3-module-%name
ceph-deploy is a way to deploy Ceph relying on just SSH access to the servers, sudo, 
and some Python. It runs fully on your workstation, requiring no servers, databases, 
or anything like that.

%package docs
Summary: Documentation for %name
Group: Development/Documentation
Requires: %name = %version-%release

%description docs
ceph-deploy is a way to deploy Ceph relying on just SSH access to the servers, sudo, 
and some Python. It runs fully on your workstation, requiring no servers, databases, 
or anything like that.

This package contains documentation for %name

%package -n python3-module-%name-tests
Summary: Tests for python3-module-%name
Group: System/Base
Requires: python3-module-%name = %version-%release

%description -n python3-module-%name-tests
ceph-deploy is a way to deploy Ceph relying on just SSH access to the servers, sudo, 
and some Python. It runs fully on your workstation, requiring no servers, databases, 
or anything like that.

This package contains tests for python3-module-%name

%prep
%setup

sed -i 's|sphinx-build|sphinx-build-3|' docs/Makefile

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

sed -i 's/python-module/python3-module/g' ceph_deploy/hosts/alt/uninstall.py

%build
%python3_build

export PYTHONPATH=$PWD
%make -C docs man

%install
%python3_install

install -pDm644 docs/build/man/%name.1 %buildroot%_man1dir/%name.1

%files
%doc LICENSE README.rst
%_bindir/%name
%_man1dir/*

%files -n python3-module-%name
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests/

%files -n python3-module-%name-tests
%python3_sitelibdir/*/tests/


%changelog
