%def_without scglib
%def_enable gcdmaster

Name: cdrdao
Version: 1.2.5
Release: alt4

Summary: Cdrdao - Write audio CD-Rs in disk-at-once mode
Group: Archiving/Cd burning
License: GPLv2
Url: http://cdrdao.sourceforge.net

Source: http://prdownloads.sourceforge.net/%name/%name-%version.tar.bz2
Source1: %name.control
# https://github.com/cdrdao/cdrdao/commit/251a40ab.patch
Patch10: %name-1.2.5-up-Fix-uninitialized-TOC-data-file-name.patch
# https://github.com/cdrdao/cdrdao/pull/25
# https://github.com/cdrdao/cdrdao/commit/ada9f82dbab5b07da49ca47e0b799b456d696b1a.patch
# otherwise brasero will fail to detect it
Patch11: %name-1.2.5-up-fix-version-command.patch

Patch2000: %name-e2k.patch
Requires(pre,postun): control

%define lame_ver 3.100

BuildRequires: gcc-c++ libacl-devel libao-devel liblame-devel >= %lame_ver
BuildRequires: libmad-devel libvorbis-devel
BuildRequires: libGConf-devel
%{?_enable_gcdmaster:BuildRequires: libgtkmm3-devel}

%description
Writes audio CD-Rs in disc-at-once (DAO) mode allowing
control over pre-gaps (length down to 0, nonzero audio data)
and sub-channel information like ISRC codes. All data that
is written to the disc must be specified with a text file.
Audio data may be in WAVE or raw format.

%package -n gcdmaster
Summary: Graphical front end to cdrdao for composing audio CDs
Group: Archiving/Cd burning
Requires: %name = %EVR

%description -n gcdmaster
gcdmaster allows the creation of toc-files for cdrdao and
can control the recording process. Its main application is
the composition of audio CDs from one or more audio files.
It supports PQ-channel editing, entry of meta data like
ISRC codes/CD-TEXT and non destructive cut of the audio data.

%prep
%setup
%patch10 -p1
%patch11 -p1
%ifarch %e2k
# mcst#7806: EDG archdep deficiency
%patch2000 -p2
%endif
# AC_CHECK_INCLUDES_DEFAULT available in 2.70 as compatibility macro
sed -i 's|\(AC_\)CHECK_\(INCLUDES_DEFAULT\)|\1\2|' configure.ac

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure \
    --with-mp3-support \
    --with-ogg-support \
    %{?_disable_gcdmaster:--without-gcdmaster} \
    %{subst_with scglib}
%nil
%make_build

%install
%makeinstall_std

# control support
install -pD -m755 %SOURCE1 %buildroot%_controldir/%name
chmod 700 %buildroot%_bindir/%name

%pre
%pre_control %name

%post
%post_control %name

%files
%_bindir/%name
%_bindir/cue2toc
%_bindir/toc2cddb
%_bindir/toc2cue
%_bindir/toc2mp3
%_datadir/%name
%_man1dir/*
%{?_enable_gcdmaster:%exclude %_man1dir/gcdmaster*}
%config /etc/control.d/facilities/%name
%doc README CREDITS ChangeLog

%if_enabled gcdmaster
%files -n gcdmaster
%_bindir/gcdmaster
%_desktopdir/gcdmaster.desktop
%_datadir/glib-2.0/schemas/org.gnome.gcdmaster.gschema.xml
%_datadir/pixmaps/gcdmaster*.png
%_man1dir/gcdmaster*
%_datadir/application-registry/gcdmaster.applications
%_datadir/mime-info/gcdmaster.*
%_datadir/mime/packages/gcdmaster.xml
%_datadir/gcdmaster/glade/Preferences.glade
%_datadir/gcdmaster/glade/ProjectChooser.glade
%endif

%changelog
