%define _unpackaged_files_terminate_build 1

Name: ccache
Version: 4.6
Release: alt3

Summary: Compiler cache
License: GPLv3+
Group: Development/Tools

Url: http://ccache.dev/
# Source-git: https://github.com/ccache/ccache.git
Source: %name-%version.tar
Patch: %name-%version-alt.patch
Patch1: 0001-Fix-build-on-GCC13.patch

BuildRequires: asciidoctor
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libhiredis-devel
BuildRequires: libzstd-devel
BuildRequires: rpm-build-python3

%description
ccache is a compiler cache. It acts as a caching pre-processor to
C/C++ compilers, using the -E compiler switch and a hash to detect
when a compilation can be satisfied from cache. This often results
in a 5 to 10 times speedup in common compilations.

%prep
%setup
%patch -p1
%patch1 -p1

%build
%cmake -DCMAKE_BUILD_TYPE=RelWithDebInfo
%cmake_build

%install
%cmakeinstall_std
mkdir -p -m755 %buildroot%prefix/lib/ccache
mkdir -p -m755 %buildroot%prefix/lib/rpm
mkdir -p -m755 %buildroot%_sbindir
install -p -m 0755 update-ccache-symlinks.py %buildroot%_sbindir/update-ccache-symlinks
install -p -m 0755 ccache.filetrigger %buildroot%prefix/lib/rpm


mkdir -p %buildroot%_sysconfdir/buildreqs/packages/ignore.d
cat > %buildroot%_sysconfdir/buildreqs/packages/ignore.d/%name << EOF
%name
EOF

%files
%doc LICENSE.adoc README.md GPL-3.0.txt
%doc doc
%_man1dir/ccache.1*
%_bindir/ccache
%_sbindir/update-ccache-symlinks
%_sysconfdir/buildreqs/packages/ignore.d/*
# XXX: don't change this to %_lib, please!
%dir %prefix/lib/ccache
%prefix/lib/rpm/ccache.filetrigger

%changelog
