%define rname cantor

%def_enable python3
%def_disable luajit
%ifarch %qt6_qtwebengine_arches
%def_enable qtwebengine
%else
%def_disable qtwebengine
%endif

%define cantor_sover 28
%define libcantorlibs libcantorlibs%cantor_sover
%define cantor_config_sover 0
%define libcantor_config libcantor_config%cantor_config_sover

Name: %rname
Version: 25.08.2
Release: alt1
%K6init

Group: Education
Summary: KDE Frontend to Mathematical Software
Url: http://www.kde.org
License: GPL-2.0-or-later or GPL-3.0-only

%if_enabled qtwebengine
Requires: kalgebra
Requires: epstool
%endif
Provides:  kde5-cantor = %EVR
Obsoletes: kde5-cantor < %EVR

Source: %rname-%version.tar
Patch1: alt-lib-so-ver.patch
Patch2: alt-find-luajit.patch

BuildRequires(pre): rpm-build-kf6 rpm-macros-qt6-webengine
BuildRequires: extra-cmake-modules qt6-svg-devel qt6-declarative-devel qt6-tools-devel qt6-5compat-devel
%if_enabled qtwebengine
BuildRequires: qt6-webengine-devel
%endif
BuildRequires: libcln-devel libspectre-devel libdiscount-devel libpoppler-qt6-devel
BuildRequires: libxml2-devel libxslt-devel
%{?_enable_python3:BuildRequires: python3-devel}
%{?_enable_luajit:BuildRequires: liblua5-devel libluajit-devel}
BuildRequires: analitza-devel
BuildRequires: kf6-karchive-devel kf6-kauth-devel kf6-kbookmarks-devel kf6-kcodecs-devel kf6-kcompletion-devel kf6-kconfig-devel
BuildRequires: kf6-kconfigwidgets-devel kf6-kcoreaddons-devel kf6-kcrash-devel kf6-kdoctools-devel
BuildRequires: kf6-ki18n-devel kf6-kiconthemes-devel kf6-kio-devel kf6-kitemviews-devel kf6-kjobwidgets-devel
BuildRequires: kf6-knewstuff-devel kf6-kparts-devel kf6-kpty-devel kf6-kservice-devel kf6-ktexteditor-devel
BuildRequires: kf6-ktextwidgets-devel kf6-kwidgetsaddons-devel kf6-kxmlgui-devel kf6-solid-devel kf6-sonnet-devel
BuildRequires: kf6-syntax-highlighting-devel

%description
Cantor is a front-end to powerful mathematics and statistics packages.
Cantor integrates them into the KDE Platform and provides a nice, worksheet-based, graphical user interface.
It supports environments for KAlgebra, Lua, Maxima, R, Sage, Octave, Python, Scilab, and Qalculate!

%package common
Summary: %name common package
Group: System/Configuration/Other
#BuildArch: noarch
Requires: kf6-filesystem
Provides:  kde5-cantor-common = %EVR
Obsoletes: kde5-cantor-common < %EVR
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n %libcantorlibs
Group: System/Libraries
Summary: %name library
Requires: %name-common >= %EVR
%description -n %libcantorlibs
%name library

%package -n %libcantor_config
Group: System/Libraries
Summary: %name library
Requires: %name-common >= %EVR
%description -n %libcantor_config
%name library


%prep
%setup -n %rname-%version
%patch1 -p1
%patch2 -p1

#LUA_BASE_VER=`echo "%{get_version libluajit-devel}" | sed -E 's|^([[:digit:]]+\.[[:digit:]]).*|\1|'`
#pushd src/backends/lua
#for f in *.{h,cpp} ; do
#    sed -i "s|luajit-2.0/lua.hpp|luajit-${LUA_BASE_VER}/lua.hpp|" $f
#done
#popd

%build
%if_enabled qtwebengine
%K6build \
    -DKDE_INSTALL_INCLUDEDIR=%_K6inc \
    #
%endif

%install
%if_enabled qtwebengine
%K6install
%K6install_move data cantor knsrcfiles
mv %buildroot/%_K6xdgmime/cantor{,-kde6}.xml
%find_lang %name --with-kde --all-name
%else
mkdir -p %buildroot
%endif

%files
%if_enabled qtwebengine
%_K6bin/cantor*
%_K6lib/cantor_pythonbackend.so
%_K6plug/kf6/parts/*cantor*.so
%_K6plug/cantor_plugins/
%_K6data/cantor/
%_K6cfg/*.kcfg
%_K6xdgapp/org.kde.cantor.desktop
%_K6icon/*/*/apps/*.*
%_K6data/knsrcfiles/*cantor*.knsrc
%_K6xdgmime/*cantor*.xml
%_datadir/metainfo/*.xml
%endif

%if_enabled qtwebengine
%files common -f %name.lang
%doc LICENSES/*

%files devel
%_K6inc/cantor/
%_K6link/lib*.so
%_libdir/cmake/Cantor/

%files -n %libcantorlibs
%_K6lib/libcantorlibs.so.%cantor_sover
%_K6lib/libcantorlibs.so.*
%files -n %libcantor_config
%_K6lib/libcantor_config.so.%cantor_config_sover
%_K6lib/libcantor_config.so.*
%endif

%changelog
