Name: canl-java
Version: 2.8.3
Release: alt1
Summary: EMI Common Authentication library - bindings for Java
#		The main parts of the code are BSD
#		Parts derived from glite security utils java are Apache 2.0
#		Parts derived from bouncycastle are MIT
#		Parts derived from Apache Commons IO are Apache 2.0
#		See LICENSE.txt for details
License: BSD and Apache-2.0 and MIT
Group: Development/Java
URL: https://github.com/eu-emi/%{name}/
Source0: https://github.com/eu-emi/%{name}/archive/canl-%{version}/canl-%{version}.tar.gz
# Disable tests that require network connections
Patch0:	%{name}-test.patch

BuildArch:	noarch

BuildRequires(pre): rpm-macros-java
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-default
BuildRequires: maven-local
BuildRequires: mvn(commons-io:commons-io) >= 2.4
BuildRequires: mvn(junit:junit) >= 4.8
BuildRequires: mvn(org.assertj:assertj-core)
BuildRequires: mvn(org.bouncycastle:bcpkix-jdk15on) >= 1.69
BuildRequires: mvn(org.bouncycastle:bcprov-jdk15on) >= 1.69
Requires: mvn(org.bouncycastle:bcpkix-jdk15on) >= 1.69
Requires: mvn(org.bouncycastle:bcprov-jdk15on) >= 1.69

%description
This is the Java part of the EMI caNl -- the Common Authentication Library.

%package javadoc
Group: Development/Java
Summary: Javadoc documentation for %{name}
BuildArch: noarch

%description javadoc
Javadoc documentation for EMI caNl.

%prep
%setup -q -n %{name}-canl-%{version}
%patch0 -p1

%pom_change_dep org.bouncycastle:bcprov-jdk18on org.bouncycastle:bcprov-jdk15on
%pom_change_dep org.bouncycastle:bcpkix-jdk18on org.bouncycastle:bcpkix-jdk15on

# Remove maven-wagon-webdav-jackrabbit dependency
%pom_xpath_remove pom:build/pom:extensions

# GPG signing requires a GPG key
%pom_remove_plugin org.apache.maven.plugins:maven-gpg-plugin

# F33+ and EPEL8+ doesn't use the maven-javadoc-plugin to generate javadoc
# Remove maven-javadoc-plugin configuration to avoid build failure
%pom_remove_plugin org.apache.maven.plugins:maven-javadoc-plugin

# Do not create source jars
%pom_remove_plugin org.apache.maven.plugins:maven-source-plugin

# Do not stage
%pom_remove_plugin org.sonatype.plugins:nexus-staging-maven-plugin

%build
%mvn_build

%install
%mvn_install

%files -f .mfiles
%dir %{_javadir}/%{name}
%doc API-Changes.txt README.md
%doc --no-dereference LICENSE.txt

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE.txt

%changelog
