#Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1
%define sover 3

Name: cairo-dock
Version: 3.6.0
Release: alt1

Summary: A light and eye-candy system panel to launch your programs easily
Summary(ru_RU.UTF-8): Лёгкая и привлекательная системная панель для удобного запуска программ
License: GPL-3.0-or-later AND GPL-2.0-or-later AND LGPL-3.0-or-later
Group: Graphical desktop/Other

URL: https://github.com/Cairo-Dock/cairo-dock-core
VCS: https://github.com/Cairo-Dock/cairo-dock-core

Obsoletes: %name-data < %version

Source: %name-%version.tar

Buildrequires(pre): rpm-macros-cmake
BuildRequires(pre): /proc
BuildRequires: cmake
BuildRequires: pkgconfig(glib-2.0)
BuildRequires: pkgconfig(gthread-2.0)
BuildRequires: pkgconfig(cairo)
BuildRequires: pkgconfig(librsvg-2.0)
BuildRequires: pkgconfig(dbus-1)
BuildRequires: pkgconfig(dbus-glib-1)
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(gl)
BuildRequires: pkgconfig(glu)
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(wayland-client)
BuildRequires: pkgconfig(xtst)
BuildRequires: pkgconfig(xcomposite)
BuildRequires: pkgconfig(xrandr)
BuildRequires: pkgconfig(gtk+-3.0)
#BuildRequires: pkgconfig(json-c)
BuildRequires: pkgconfig(wayland-egl)
BuildRequires: pkgconfig(xinerama)
BuildRequires: pkgconfig(gtk-layer-shell-0)
BuildRequires: extra-cmake-modules

%description
Cairo-Dock is a pretty, light and convenient interface to your desktop,
able to replace advantageously your system panel! It features multi-docks,
taskbar, launchers and a lot of useful applets that can be detached from
the dock to act as desktop widgets.

%description -l ru_RU.UTF-8
Cairo-Dock — это красивый, лёгкий и удобный интерфейс для вашего рабочего стола,
способный с успехом заменить системную панель! Он включает в себя мультидоки,
панель задач, лаунчеры и множество полезных апплетов, которые можно отсоединить
от дока и использовать в качестве виджетов рабочего стола.

%package -n libgldi%sover
Summary: Library for cairo-dock
Group: System/Libraries

%description -n libgldi%sover
This package is a library for cairo-dock.

%package devel
Summary: Development files for cairo-dock
Group: Development/Other
Requires: libgldi%sover = %EVR

%description devel
This package provides include files and libraries for cairo-dock functions.

%prep
%setup -n %name-%version

%build
%cmake \
	-DCMAKE_BUILD_TYPE=Release \
	-Denable-desktop-manager=False \
	-Denable-systemd-service=True

%cmake_build

%install
%cmake_install
%find_lang %name

%files -f %name.lang
%_bindir/%name
%_desktopdir/*.desktop
%_datadir/%name
%_man1dir/*.1.*
%_pixmapsdir/*.svg
%_libdir/%name
%_user_unitdir/*.service

%files -n libgldi%sover
%_libdir/libgldi.so.%sover
%_libdir/libgldi.so.%sover.*

%files devel
%_includedir/%name
%_libdir/libgldi.so
%_pkgconfigdir/*.pc

%changelog
