Name: bzip2
Version: 1.0.8
Release: alt3
Epoch: 1

Summary: A file compression utility
License: bzip2-1.0.6
Group: Archiving/Compression
Url: https://www.sourceware.org/bzip2/

# git://git.altlinux.org/gears/b/bzip2.git
Source: %name-%version-%release.tar

Requires: bzlib = %EVR
BuildPreReq: glibc-devel-static makeinfo

%package -n bzlib
Summary: The bzlib compression and decompression library
Summary(ru_RU.UTF-8): Библиотека сжатия данных bzlib
Group: System/Libraries

%package -n bzlib-devel
Summary: Include files for developing apps which will use bzip2
Group: Development/C
Provides: %name-devel = %version
Obsoletes: %name-devel
Requires: bzlib = %EVR

%package -n bzlib-devel-static
Summary: Static library for developing apps which will use bzip2
Group: Development/C
Provides: %name-devel-static = %version
Obsoletes: %name-devel-static
Requires: bzlib-devel = %EVR

%description
bzip2 is a freely available, patent-free, high quality data compressor.

bzip2 compresses files using the Burrows-Wheeler block sorting text
compression algorithm and Huffman coding.  Compression is generally
considerably better than that achieved by more conventional
LZ77/LZ78-based compressors (such as gzip), and approaches the
performance of the PPM family of statistical compressors.  bzip2 is
by far not the fastest compression utility, but it does strike a
balance between speed and compression capability.

The command-line options are deliberately very similar to those of
GNU Gzip, but they are not identical.

%description -n bzlib
The bzip2 compression library provides in-memory compression and
decompression functions, including integrity checks of the uncompressed
data.  The bzip2 library is used by many different system programs.

%description -n bzlib-devel
This package contains the include files needed to develop programs that
use the bzip2 compression and decompression library.

%description -n bzlib-devel-static
This package contains the static library needed to develop statically
linked programs that use the bzip2 compression and decompression
library.

%prep
%setup -n %name-%version-%release

%build
%global optflags_lto %optflags_lto -ffat-lto-objects
%define _optlevel 3
%add_optflags -Winline
%ifarch %ix86 x86_64
%add_optflags -momit-leaf-frame-pointer
%endif

%autoreconf
%configure --enable-shared --enable-static
%make_build

%check
%make_build -k check

%install
%makeinstall_std

# Relocate shared libraries from %_libdir/ to /%_lib/.
mkdir %buildroot/%_lib
for f in %buildroot%_libdir/*.so; do
	t=$(readlink "$f")
	ln -sf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

# Relocate binaries and manpages
pushd %buildroot
	mkdir -p bin sbin
	mv .%_bindir/* bin/

	for f in bzip bunzip; do
		ln -s ../../bin/bzip2 .%_bindir/$f
		ln -s bzip2.1 .%_man1dir/$f.1
	done
	ln -s ../../bin/bzip2 .%_bindir/bzip2
	for f in bunzip2 bzcat; do
		ln -s bzip2 .%_bindir/$f
	done
	for f in bzip2recover; do
		ln -s ../../bin/$f .%_bindir/$f
		ln -s bzip2.1 .%_man1dir/$f.1
	done

	# Our bzless and bzmore live in less package.
	rm bin/bz{less,more} .%_man1dir/bz{less,more}.*

	# Our bzdiff, bzcmp and bz*grep live in gzip-utils package.
	rm .{/bin,%_man1dir}/{bzdiff,bzcmp,bzgrep,bzfgrep,bzegrep}*
popd

# Package pkgconfig file
mkdir -p %buildroot%_pkgconfigdir
cat > %buildroot%_pkgconfigdir/%name.pc <<'EOF'
prefix=%_prefix
exec_prefix=%_exec_prefix
libdir=%_libdir
includedir=%_includedir

Name: %name
Version: %version
Description: bzlib compression and decompression library
Libs: -lbz2
Cflags:
EOF

%define docdir %_docdir/%name
rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir
install -pm644 CHANGES LICENSE README %buildroot%docdir/

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%files -n bzlib
/%_lib/*
%dir %docdir/
%docdir/LICENSE

%files -n bzlib-devel
%_libdir/*.so
%_includedir/*
%_infodir/*.info*
%_pkgconfigdir/%name.pc

%files -n bzlib-devel-static
%_libdir/*.a

%files
/bin/*
%_bindir/b*zip*
%_bindir/bzcat
%_man1dir/b*zip*.*
%_man1dir/bzcat.*
%dir %docdir/
%docdir/[CR]*

%changelog
