%global provider        github
%global provider_tld    com
%global project         containers
%global repo            buildah
# https://github.com/containers/buildah
%global provider_prefix %provider.%provider_tld/%project/%repo
%global import_path     %provider_prefix

%global _unpackaged_files_terminate_build 1

Name: buildah
Version: 1.41.4
Release: alt1
Summary: A command line tool used to creating OCI Images
Group: Development/Other
License: Apache-2.0 AND BSD-2-Clause AND BSD-3-Clause AND ISC AND MIT AND MPL-2.0
Url: https://%provider_prefix
Source: %name-%version.tar
Patch: %name-%version.patch

ExclusiveArch: %go_arches
BuildRequires(pre): rpm-macros-golang
BuildRequires: rpm-build-golang golang >= 1.23.3
BuildRequires: go-md2man
BuildRequires: libgpgme-devel
BuildRequires: libbtrfs-devel
BuildRequires: libassuan-devel
BuildRequires: libseccomp-devel
BuildRequires: glib2-devel
BuildRequires: libsubid-devel
BuildRequires: libsqlite3-devel
BuildRequires: libsystemd-devel

Requires: tzdata
Requires: containers-common-extra
%ifnarch %e2k %arm %ix86
Requires: netavark >= 1.6.0
%endif

%description
The buildah package provides a command line tool which can be used to
* create a working container from scratch
or
* create a working container from an image as a starting point
* mount/umount a working container's root file system for manipulation
* save container's root file system layer to create a new image
* delete a working container or an image

%prep
%setup
%patch -p1
sed -i '/docs install/d' Makefile

%build
export BUILDDIR="$PWD/.gopath"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"
export VERSION=%version
export GIT_COMMIT=%release
export BRANCH=altlinux
export GOMD2MAN=go-md2man

%golang_prepare
pushd .gopath/src/%import_path
#%%golang_build cmd/%%name
%make all PREFIX=%_prefix
popd

%install
export BUILDDIR="$PWD/.gopath"
export GOPATH="%go_path"

pushd .gopath/src/%import_path
#%%golang_install
# rm -rf -- %%buildroot%%_datadir
%make DESTDIR=%buildroot PREFIX=%prefix install
%make DESTDIR=%buildroot PREFIX=%prefix install.completions
%make DESTDIR=%buildroot PREFIX=%prefix -C docs install
for bin in copy dumpspec imgtype inet passwd tutorial; do
    install -m 0755 bin/$bin %buildroot%_bindir/%name-$bin
done
popd

%files
%doc LICENSE
%doc README.md
%_bindir/%{name}*
%_man1dir/*
%_datadir/bash-completion/completions/*

%changelog
