%global glib2_version 2.64
%global gtk3_version 3.24
%global vala_version 0.48

Name: budgie-desktop-view
Version: 1.3
Release: alt1

Summary: Official Budgie desktop icons application / implementation

License: Apache-2.0
Group: Graphical desktop/Other
Url: https://github.com/BuddiesOfBudgie/budgie-desktop-view

# Source0-url: %url/releases/download/v%version/%name-v%version.tar.xz
Source0: %name-%version.tar

Patch0: 0001-fix-compilation-under-newer-meson-and-gcc.patch

BuildRequires(pre):  rpm-macros-meson

BuildRequires: pkgconfig(glib-2.0) >= %glib2_version
BuildRequires: pkgconfig(gio-unix-2.0) >= %glib2_version
BuildRequires: pkgconfig(gdk-3.0) >= %gtk3_version
BuildRequires: pkgconfig(gtk+-3.0) >= %gtk3_version
BuildRequires: pkgconfig(vapigen) >= %vala_version

BuildRequires: desktop-file-utils
BuildRequires: intltool
BuildRequires: meson
BuildRequires: vala

%description
Official Budgie desktop icons application / implementation.

%prep
%setup

%build
%meson -Dwerror=false
%meson_build

%install
%meson_install
%find_lang %name

%check
desktop-file-validate %buildroot%_desktopdir/org.buddiesofbudgie.budgie-desktop-view.desktop

%files -f %name.lang
%doc README.md
%doc LICENSE.md
%_bindir/org.buddiesofbudgie.budgie-desktop-view
%_desktopdir/org.buddiesofbudgie.budgie-desktop-view.desktop
%_datadir/glib-2.0/schemas/org.buddiesofbudgie.budgie-desktop-view.gschema.xml
%_sysconfdir/xdg/autostart/org.buddiesofbudgie.budgie-desktop-view-autostart.desktop

%changelog
