%def_with check

Name: broot
Version: 1.47.0
Release: alt1
Summary: A new way to see and navigate directory trees
License: MIT
Group: File tools
Url: https://dystroy.org/broot
VCS: https://github.com/Canop/broot

Source: %name-%version.tar
Source1: vendor.tar
Patch: alt-fix-build-nix-on-loongarch64.patch

ExcludeArch: i586

BuildRequires(pre): rpm-build-rust
BuildRequires: cargo-vendor-checksum
BuildRequires: diffstat
BuildRequires: rust-cargo

%description
%summary.

%prep
%setup -a 1
%patch -p1
diffstat -p1 -l < %PATCH0 | sed -re 's@vendor/@@' | xargs -r cargo-vendor-checksum -f
mkdir -p .cargo
cat >> .cargo/config.toml <<EOF
[source.crates-io]
replace-with = "vendored-sources"

[source.vendored-sources]
directory = "vendor"

[profile.release]
debug = true
strip = false
EOF

%build
%rust_build

%install
%rust_install
install -Dm 0644 man/page %buildroot%_man1dir/%name.1

%check
%rust_test

%files
%_bindir/%name
%_man1dir/%name.1.*

%changelog
