# vim:set ft=spec: -*- rpm-spec -*-
Name: briquolo
Version: 0.5.7
Release: alt7

Group: Games/Arcade
Summary: OpenGL-based 3D breakout
Summary(ru_RU.UTF-8): Трёхмерный арканоид использующий OpenGL
Summary(be_BY.UTF-8): Трохмерны арканоід, які карыстае OpenGL
License: GPLv2
Url: http://briquolo.free.fr
Packager: Gleb Stiblo <ulfr@altlinux.ru>

Source: %name-%version.tar
Source1: briquolo.16.png
Source2: briquolo.32.png
Source3: briquolo.48.png
Patch01: briquolo-0.5.7-strncmp.patch
Patch02: briquolo-0.5.7-alt-libpng15.patch

# Automatically added by buildreq on Thu Sep 04 2008
BuildRequires: gcc-c++ imake libSDL_sound-devel libSDL_mixer-devel libSDL_ttf-devel libX11-devel libfreetype-devel libpng-devel xorg-cf-files
Requires: fonts-ttf-dejavu

%description
BRIQUOLO is a breakout with 3D representation based on OpenGL.

%description -l ru_RU.UTF-8
BRIQUOLO это трёхмерный арканоид. Кубики и бита находятся в бассейне
с водой. Виды от первого и третьего лица, бонусы, различные виды
кубиков, трёхмерная графика делают игру достаточно интересной и
привлекательной.

%description -l be_BY.UTF-8
BRIQUOLO гэта трохмерны арканоід. Цагліны і біта знаходзяцца ў басэйне
з вадой. Віды ад першага і трэцяга ліку, бонусы, розныя тыпы цэглы,
трохмерная графіка робяць гульню дастаткова цікавай і прывабнай.

%prep
%setup
%patch01 -p1
%patch02 -p2

%build
%add_optflags -std=gnu++14
%configure --bindir=%_gamesbindir --datadir=%_gamesdatadir
%make_build

%install
mkdir -p %buildroot%_gamesdatadir/applications
%makeinstall_std
mv %buildroot/%_gamesdatadir/locale %buildroot%_datadir/
rm -rf %buildroot%_gamesdatadir/applications
rm -rf %buildroot%buildroot

mkdir -p %buildroot/{%_miconsdir,%_liconsdir,%_niconsdir,%_pixmapsdir,%_desktopdir}
cat > %buildroot/%_desktopdir/%name.desktop <<EOF
[Desktop Entry]
Name=Briquolo
GenericName=BreakOut
Comment=An OpenGL breakout

Type=Application
Categories=ArcadeGame;Game;

TryExec=briquolo
Exec=briquolo

Icon=briquolo
Terminal=false
EOF

install -m 644 %SOURCE1 %buildroot/%_miconsdir/%name.png
install -m 644 %SOURCE2 %buildroot/%_niconsdir/%name.png
install -m 644 %SOURCE3 %buildroot/%_liconsdir/%name.png
install -m 644 %SOURCE3 %buildroot/%_pixmapsdir/%name.png
%find_lang %name

# remove bundled font (see ALT 25349)
rm -f %buildroot%_datadir/games/briquolo/data/DejaVuSans.ttf
ln -srf %buildroot%_datadir/fonts/ttf/dejavu/DejaVuSans.ttf %buildroot%_datadir/games/briquolo/data/DejaVuSans.ttf

%files -f %name.lang
%_desktopdir/%name.desktop
%_gamesbindir/%name
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png
%_gamesdatadir/%name
%_pixmapsdir/%name.png
%doc README*

%changelog
