%define _unpackaged_files_terminate_build 1

%def_with doc
%def_without check
%def_with urwid

Name: bpython
Version: 0.25
Release: alt1

Summary: Fancy curses interface to the Python 3 interactive interpreter

License: MIT
Group: Development/Python3
Url: https://bpython-interpreter.org/
VCS: https://github.com/bpython/bpython.git

BuildArch: noarch

# Source-url: https://github.com/bpython/bpython/archive/refs/tags/%version-release.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx python3-module-sphinx-sphinx-build-symlink

%if_with check
BuildRequires: /dev/pts
BuildRequires: python3-module-pyxdg
BuildRequires: python3-module-curtsies
BuildRequires: python3-module-greenlet
BuildRequires: python3-module-typing_extensions
%endif

Provides: bpython3 = %EVR
Obsoletes: bpython3

Provides: bpython3-curses = %EVR
Obsoletes: bpython3-curses

%description
bpython is a fancy interface to the Python interpreter for
Unix-like operating systems.

It has the following features:
 - In-line syntax highlighting.
 - Readline-like autocomplete with suggestions displayed as you type.
 - Expected parameter list for any Python function.
 - "Rewind" function to pop the last line of code from memory and
   re-evaluate.
 - Send the code you've entered off to a pastebin.
 - Save the code you've entered to a file.
 - Auto-indentation

%package doc
Group: Development/Python3
Summary: Documentation for bpython

Provides: bpython3-doc = %EVR
Obsoletes: bpython3-doc

%description doc
Documentation for bpython

%package urwid
Group: Development/Python3
Summary: Urwid front-end for bpython
Requires: %name = %EVR

Provides: bpython3-urwid = %EVR
Obsoletes: bpython3-urwid

%description urwid
Urwid front-end for bpython

%prep
%setup
echo "__version__ = '%version'" > bpython/_version.py

%if_with doc
%prepare_sphinx3 doc/sphinx
ln -s ../objects.inv doc/sphinx/source/
%endif

%build
%pyproject_build

%if_with doc
pushd doc/sphinx/source
sphinx-build-3 -b html -d build/doctrees . html
popd
%endif

%install
%pyproject_install

%check
python3 setup.py test

%files
%_bindir/bpdb
%_bindir/%name
%python3_sitelibdir/%name/
%exclude %python3_sitelibdir/%name/urwid.py
%exclude %python3_sitelibdir/%name/test
%python3_sitelibdir/bpdb/
%python3_sitelibdir/bpython-%version.dist-info
%_datadir/metainfo/*
%_datadir/applications/*
%_pixmapsdir/%name.png
%_man1dir/*
%_man5dir/*

%if_without urwid
%exclude %_bindir/%{name}-urwid
%endif


%if_with doc
%files doc
%doc doc/sphinx/source/html
%endif


%if_with urwid
%files urwid
%_bindir/%{name}-urwid
%python3_sitelibdir/%name/urwid.py
%endif

%changelog
