%define _unpackaged_files_terminate_build 1

Name: bootc
Version: 1.9.0
Release: alt1

Summary: Boot and upgrade via container images
License: Apache-2.0 AND BSD-3-Clause AND MIT AND (Apache-2.0 OR BSL-1.0) AND (Apache-2.0 OR MIT) AND (Apache-2.0 WITH LLVM-exception OR Apache-2.0 OR MIT) AND (Unlicense OR MIT)
Group: System/Base
Url: https://github.com/containers/bootc
Vcs: https://github.com/containers/bootc.git

# i586 not supported
# https://github.com/containers/bootc/blob/main/lib/src/install/baseline.rs#L252
ExclusiveArch: x86_64 ppc64le aarch64

Source: %name-%version.tar
Source10: vendor.tar
Patch: %name-%version-%release.patch

Requires: composefs
Requires: ostree
Requires: skopeo
Requires: podman
Requires: bootupd

BuildRequires: rpm-build-rust
BuildRequires: rust-cargo
BuildRequires: go-md2man
BuildRequires: pkgconfig(libzstd)
BuildRequires: pkgconfig(openssl)
BuildRequires: pkgconfig(ostree-1) >= 2025.3

%description
Transactional, in-place operating system updates using OCI/Docker container images.

Contains update, test and create commands.

%package -n system-reinstall-bootc
Summary: Utility to reinstall the current system via bootc
Group: Other

Requires: podman

%description -n system-reinstall-bootc
This package provides a utility to simplify reinstalling the current system to a given bootc image.

%prep
%setup -a10
%autopatch -p1

%build
%make_build

%install
%makeinstall_std
# Remove broken link
rm -fv -- %buildroot/%_prefix/lib/%name/storage
# Needs only for Rad Hat
rm -fv -- %buildroot/%_unitdir/bootc-publish-rhsm-facts.service

%check
%make test-bin-archive

%post
# Create link to ostree bootc storage removed at %install
if [ -e /sysroot/ostree/bootc/storage ] && [ ! -L "%_prefix/lib/%name/storage" ]; then
    ln -s -- /sysroot/ostree/bootc/storage "%_prefix/lib/%name/storage"
fi

%preun
# Remove file created in %post
if [ -e "%_prefix/lib/%name/storage" ]; then
    rm -fv -- "%_prefix/lib/%name/storage"
fi

%files
%_bindir/%name
%_prefix/lib/%name/
%_gen_dir/bootc-systemd-generator/
%_unitdir/bootc-*
%_unitdir/composefs-finalize-staged.service
%_docdir/%name/
%_man5dir/bootc*
%_man8dir/bootc*
%_man8dir/system-reinstall-bootc*
%doc README.md

%files -n system-reinstall-bootc
%_bindir/system-reinstall-bootc

%changelog
