%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,lint=relaxed
%define git %nil
%define kern_dir scripts/addons_core/cycles/lib

%def_with docs

%ifarch aarch64 x86_64 %e2k
%def_with embree
%else
%def_without embree
%endif

%ifarch x86_64
%def_with cuda
%def_with hiprt
# oneapi needs sycl compiler
%def_without levelzero
%else
%def_without cuda
%def_without hiprt
%def_without levelzero
%endif

%ifarch x86_64 aarch64 loongarch64
%def_with mold
%else
%def_without mold
%endif

%ifarch x86_64 aarch64
%def_with openpgl
%def_with usd
%def_with oidn
%else
%def_without openpgl
%def_without usd
%def_without oidn
%endif

%ifarch %e2k
# error: cpio archive too big - 4690M
%define optflags_debug -g0
%endif

# https://devtalk.blender.org/t/does-blender-use-jemalloc-and-or-tbb/13388/10
%def_with jemalloc

%ifarch x86_64 aarch64
# HIP should work on other 64-bit arches but clr needs to get built first
%def_with hip
%else
%def_without hip
%endif

Name: blender
Version: 4.3.2
Release: alt1.1
Summary: 3D modeling, animation, rendering and post-production
License: GPL-3.0-or-later
Group: Graphics
URL: https://www.blender.org

# Blender doesn't officially support 32-bit build since 2.80. See also:
# https://developer.blender.org/T67184
ExcludeArch: %ix86 %arm

# https://projects.blender.org/blender/blender.git
Source: %name-%version.tar
# assets from blender-v4.3-release
# https://projects.blender.org/blender/blender-assets.git
Source1: blender-assets-v%version.tar

Patch21: blender-2.77-alt-enable-localization.patch
Patch22: blender-2.92-alt-include-deduplication-check-skip.patch
Patch23: blender-2.80-alt-use-system-glog.patch
Patch24: blender-2.90-alt-non-x86_64-linking.patch
Patch25: blender-3.4.1-gcc-13-fix.patch
Patch26: blender-4.0.1-alt-pcre.patch
Patch27: blender-4.3.0-upstream-Fix-FFmpeg-deprecation-warnings.patch
Patch28: blender-4.3.0-upstream-Fix-Remove-internal-ffmpeg-API-usage-fix-ffmpeg-7-co.patch
Patch29: blender-4.3.0-upstream-Cycles-Support-building-with-OpenVDB-12.patch

# needed for static clang libs
Patch30: blender-alt-fix-clang-linking.patch
Patch31: blender-alt-osl-shader-dir.patch

# needed for dynamic clang libs
Patch32: blender-4.1-alt-use-libclang.patch
Patch33: blender-alt-cycles-aarch64-hip-cuda-fix.patch

# need to send this to upstream:
# gfx900 needs -O1 on Linux too, otherwise it will fail
# https://github.com/ROCm/llvm-project/issues/58#issuecomment-2041433424
Patch34: blender-cycles-fix-hip-kernels.patch
Patch35: blender-4.4-alt-hiprt-2.5.patch
Patch36: blender-4.3.0-generic-64bit.patch
Patch37: blender-4.3.0-loongarch64.patch
Patch38: blender-4.3.0-alt-unbundle-hiprt.patch
# new OSL 1.14 API changes
# partialy implements upstream c997e614144e41351ab348ab7ef56d25ba9a3936
# and faa17e2cc673421efd48969d4ddbb60d01f649ee
Patch39: blender-4.3-osl-1.14-compat.patch
# new OIIO API 3.x changes
# upstream 4f4c3f73b697436922464e087823f53e8681d7e8
# upstream c3c05559d6a7e10981ad8e3c13a8ee7862399c78
Patch40: blender-4.3.0-upstream-update-oiio-apis.patch
# python3.12 compatibility
# ALT bug 54359
# upstream 1865de1c738a1a1ead520fbd38487815e13906e9
Patch41: blender-4.3-upstream-129926-fix-python3.12.patch
# python3.13 compatibility
# https://sources.debian.org/data/main/b/blender/4.3.2%2Bdfsg-2/debian/patches/0006-fix_FTBFS_py313.patch
Patch42: 0006-fix_FTBFS_py313.patch

Patch2000: blender-e2k-support.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: boost-filesystem-devel boost-locale-devel boost-wave-devel boost-python3-devel
BuildRequires: cmake gcc-c++
BuildRequires: ninja-build /proc
BuildRequires: libGLEW-devel libXi-devel
BuildRequires: libavdevice-devel libavformat-devel libavfilter-devel libswresample-devel
BuildRequires: libfftw3-devel >= 3.3.9 libjack-devel libopenal-devel libsndfile-devel
BuildRequires: libjpeg-devel pkgconfig(libopenjp2) libpng-devel libtiff-devel libpcre-devel libswscale-devel libxml2-devel
BuildRequires: liblzo2-devel
BuildRequires: python3-devel
BuildRequires: libnumpy-py3-devel
BuildRequires: libopenimageio-devel
BuildRequires: libopencolorio-devel
BuildRequires: openexr-devel
BuildRequires: imath-devel
BuildRequires: libpugixml-devel
BuildRequires: libglog-devel libgflags-devel eigen3-devel
BuildRequires: libXxf86vm-devel libXrender-devel
BuildRequires: tbb-devel
BuildRequires: libfreetype-devel
# Remove following dependency when libopenjpeg2.0-devel is fixed
BuildRequires: openjpeg-tools2.0
BuildRequires: alembic-devel
BuildRequires: openvdb-devel libblosc-devel
BuildRequires: libgomp-devel
BuildRequires: libgmp-devel libgmpxx-devel
BuildRequires: libharu-devel
BuildRequires: libpulseaudio-devel
BuildRequires: libpotrace-devel
BuildRequires: openshadinglanguage-devel
BuildRequires: opensubdiv-devel
BuildRequires: libzstd-devel
BuildRequires: libepoxy-devel
BuildRequires: libwayland-egl-devel wayland-protocols libwayland-cursor-devel libxkbcommon-devel libdecor-devel
BuildRequires: libvulkan-devel libshaderc-devel
BuildRequires: libspnav-devel
BuildRequires: libwebp-devel
%ifarch aarch64
BuildRequires: sse2neon-devel
%endif

%if_with embree
BuildRequires: embree-devel
%endif

%if_with jemalloc
BuildRequires: libjemalloc-devel
%endif

%if_with docs
BuildRequires: /usr/bin/doxygen
BuildRequires: python3-module-sphinx python3-module-sphinx-sphinx-build-symlink python3-module-sphinx_rtd_theme
%endif

%if_with hip
BuildRequires: hip-devel
%endif

%if_with hiprt
BuildRequires: hiprt-devel clang-rocm-devel
%endif

%if_with openpgl
BuildRequires: openpgl-devel
%endif

%if_with usd
BuildRequires: OpenUSD-devel
%endif

%if_with cuda
BuildRequires: nvidia-cuda-devel
# .cubin files are ELF files but we still don't know how
# to handle them.
%set_verify_elf_skiplist %_datadir/%name/*/%kern_dir/*.cubin
%endif

%if_with oidn
BuildRequires: openimagedenoise-devel
%endif

%if_with mold
BuildRequires: mold
%endif

%if_with levelzero
BuildRequires: liboneapi-level-zero1-devel
%endif

%add_python3_path %_datadir/%name/scripts
%add_python3_req_skip _bpy
%add_python3_req_skip _bpy_path
%add_python3_req_skip _cycles
%add_python3_req_skip _freestyle
%add_python3_req_skip bgl
%add_python3_req_skip blend
%add_python3_req_skip blf
%add_python3_req_skip idprop.types
%add_python3_req_skip gpu
%add_python3_req_skip io_scene_gltf2.blender.com
%add_python3_req_skip io_scene_gltf2.blender.exp
%add_python3_req_skip io_scene_gltf2.io.com
%add_python3_req_skip io_scene_gltf2.io.exp
%add_python3_req_skip mathutils
%add_python3_req_skip mathutils.bvhtree
%add_python3_req_skip mathutils.geometry
%add_python3_req_skip mathutils.noise
%add_python3_req_skip oscurart_tools.files
%add_python3_req_skip oscurart_tools.mesh
%add_python3_req_skip oscurart_tools.object
%add_python3_req_skip oscurart_tools.render
%add_python3_req_skip setuptools
%add_python3_req_skip bmesh
%add_python3_req_skip bpy.app.handlers
%add_python3_req_skip bpy.app.translations
%add_python3_req_skip bpy.props
%add_python3_req_skip bpy.types

AutoProv: no

Obsoletes: %name-i18n

%description
Fully integrated creation suite, offering a broad range of essential
tools for the creation of 3D content, including modeling, uv-mapping,
texturing, rigging, skinning, animation, particle and other simulation,
scripting, rendering, compositing, post-production and game creation

%description -l ru_RU.UTF-8
Полностью интегрированный пакет разработки, предлагающий широкий
выбор инструментов необходимых для создания 3D-графики. Включает
средства моделирования, анимации, рендеринга, постобработки видео,
а также создания интерактивных игр. Пакет имеет такие функции,
как динамика твердых тел, жидкостей и мягких тел, систему горячих
клавиш, большое количество легко доступных расширений, написанных
на языке Python.

%package doc
Summary: Documentation for Blender
Group: Documentation
Requires: %name = %EVR

%description doc
Fully integrated creation suite, offering a broad range of essential
tools for the creation of 3D content, including modeling, uv-mapping,
texturing, rigging, skinning, animation, particle and other simulation,
scripting, rendering, compositing, post-production and game creation.

This package contains documentation for Blender.

%description doc -l ru_RU.UTF-8
Полностью интегрированный пакет разработки, предлагающий широкий
выбор инструментов необходимых для создания 3D-графики. Включает
средства моделирования, анимации, рендеринга, постобработки видео,
а также создания интерактивных игр. Пакет имеет такие функции,
как динамика твердых тел, жидкостей и мягких тел, систему горячих
клавиш, большое количество легко доступных расширений, написанных
на языке Python.

Данный пакет содержит документацию для Blender.

%if_with hip
%package cycles-hip-kernels
Summary: Cycles precompiled binaries for HIP
Group: System/Libraries
Requires: %name = %EVR, hip-runtime-amd

%description cycles-hip-kernels
Precompiled GPU binaries for GPU accelerated rendering with Cycles on various
graphics cards.

This package contains binaries for AMD GPUs to use with HIP.
%endif

%if_with hiprt
%package cycles-hiprt-kernels
Summary: Cycles precompiled binaries for HIPRT
Group: System/Libraries
Requires: %name = %EVR, hip-runtime-amd
# hiprt version hardcoded in sources
Requires: libhiprt = 2.5-alt2.4e650d5

%description cycles-hiprt-kernels
Precompiled GPU binaries for GPU accelerated rendering with Cycles on various
graphics cards.

This package contains binaries for AMD GPUs to use with HIPRT.
NOTE: If you use HIPRT you don't need HIP kernels and vice versa!

%endif

%if_with cuda
%package cycles-cuda-kernels
Summary: Cycles precompiled binaries for CUDA
Group: System/Libraries
Provides: blender-cycles-nvidia-kernels = %EVR
Obsoletes: blender-cycles-nvidia-kernels < %EVR
Requires: %name = %EVR, libcuda

%description cycles-cuda-kernels
Precompiled GPU binaries for GPU accelerated rendering with Cycles on various
graphics cards.

This package contains binaries for Nvidia GPUs to use with CUDA.
%endif

%prep
%setup -a1

%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1
%patch25 -p1
%patch26 -p1
%patch27 -p1
%patch28 -p1
%patch29 -p1 -b .openvdb12-support

#%%patch30 -p1
%patch31 -p1
#%%patch32 -p1
%ifarch aarch64
# see https://github.com/OE4T/meta-tegra/pull/1445
%patch33 -p1
mkdir -p /tmp/bits
cat >/tmp/bits/math-vector.h <<EOF
#include <bits/libm-simd-decl-stubs.h>
#undef __ADVSIMD_VEC_MATH_SUPPORTED
#undef __SVE_VEC_MATH_SUPPORTED
EOF
%endif
%patch34 -p1 -b .hip-kernels-fixes
%patch35 -p1 -b .hiprt-2.5
%patch36 -p1
%patch37 -p1
%patch38 -p1 -b .unbundle-hiprt
%patch39 -p1 -b .osl-1.14
%patch40 -p1 -b .oiio-3.x
%patch41 -p1 -b .python3.12
%patch42 -p1 -b .python3.13

%ifarch %e2k
%patch2000 -p1
# lcc 1.25.15's EDG bug would fail building OPENVDB+TBB otherwise
sed -i "/-Werror=return-type/d" CMakeLists.txt
sed -i 's/"${CMAKE_C_COMPILER_VERSION}" VERSION_LESS/"100" VERSION_LESS/' CMakeLists.txt
sed -i 's/-freciprocal-math//' intern/cycles{,/kernel}/CMakeLists.txt
%endif

# Delete the bundled FindOpenJPEG to make find_package use the system version
# instead (the local version hardcodes the openjpeg version so it is not update
# proof)
rm -f build_files/cmake/Modules/FindOpenJPEG.cmake

# Remove bundled libraries which must not be used instead of system ones
rm -rf extern/{Eigen3,glew,lzo,gflags,glog}

%build
BUILD_DATE="$(stat -c '%%y' '%SOURCE0' | date -f - '+%%Y-%%m-%%d')"
BUILD_TIME="$(stat -c '%%y' '%SOURCE0' | date -f - '+%%H:%%M:%%S')"

# Explicitly use python3 in hashbangs.
pushd scripts/addons_core
subst '/^#!.*python$/s|python$|python3|' $(grep -Rl '#!.*python$' *)
popd

# needed due to non-standard location of pcre.h header
%add_optflags -I%_includedir/pcre -DGLOG_USE_GLOG_EXPORT

%if_with hiprt
export ALTWRAP_LLVM_VERSION=rocm
%endif
%cmake -G Ninja \
%if_with hip
	-DWITH_CYCLES_HIP_BINARIES:BOOL=ON \
%endif #hip
%if_with cuda
	-DWITH_CYCLES_CUDA_BINARIES:BOOL=ON \
%endif #cuda
%if_with hiprt
	-DHIPRT_ROOT_DIR=%prefix \
	-DWITH_CYCLES_DEVICE_HIPRT:BOOL=ON \
	-DHIPRT_INCLUDE_DIR=%_includedir \
	-DHIP_LINKER_EXECUTABLE=%_bindir/clang++-rocm \
	-DHIPRT_COMPILER_PARALLEL_JOBS=4 \
%endif #hiprt
%if_with levelzero
	-DLEVEL_ZERO_ROOT_DIR=%prefix \
	-DWITH_CYCLES_DEVICE_ONEAPI:BOOL=ON \
	-DWITH_CYCLES_ONEAPI_BINARIES:BOOL=ON \
%endif #levelzero
	-DBUILD_SHARED_LIBS=OFF \
	-DWITH_ALEMBIC:BOOL=ON \
	-DWITH_FFTW3=ON \
	-DWITH_JACK=ON \
	-DWITH_CODEC_SNDFILE=ON \
	-DWITH_IMAGE_OPENJPEG=ON \
	-DWITH_PYTHON=ON \
	-DWITH_PYTHON_INSTALL=OFF \
	-DWITH_CODEC_FFMPEG=ON \
	-DWITH_CXX_GUARDEDALLOC=OFF \
	-DWITH_INSTALL_PORTABLE=OFF \
	-DWITH_PYTHON_SAFETY=OFF \
	-DWITH_OPENMP=ON \
	-DWITH_CYCLES=ON \
%if_with embree
	-DEMBREE_ROOT_DIR=%_prefix \
	-DWITH_CYCLES_EMBREE:BOOL=ON \
%else
	-DWITH_CYCLES_EMBREE:BOOL=OFF \
%endif
%if_with usd
	-DWITH_USD:BOOL=ON \
%else
	-DWITH_USD:BOOL=OFF \
%endif
%if_with mold
	-DWITH_LINKER_MOLD=YES \
%endif
	-DWITH_OPENCOLORIO=ON \
	-DWITH_OPENVDB:BOOL=ON \
	-DWITH_OPENVDB_BLOSC:BOOL=ON \
	-DWITH_SYSTEM_LZO=ON \
	-DWITH_SYSTEM_EIGEN3:BOOL=ON \
	-DWITH_SYSTEM_GFLAGS:BOOL=ON \
	-DWITH_SYSTEM_GLOG:BOOL=ON \
	-DWITH_SYSTEM_FREETYPE:BOOL=ON \
	-DWITH_IMAGE_OPENEXR=ON \
	-DWITH_TBB:BOOL=ON \
	-DPYTHON_VERSION="%_python3_version" \
	-DBUILDINFO_OVERRIDE_DATE="$BUILD_DATE" \
	-DBUILDINFO_OVERRIDE_TIME="$BUILD_TIME" \
	-DWITH_DOC_MANPAGE:BOOL=ON \
	-DWITH_ASSERT_ABORT:BOOL=OFF \
	-DWITH_LINKER_GOLD:BOOL=OFF \
	-DWITH_OPENSUBDIV:BOOL=ON \
	-DOPENEXR_INCLUDE_DIRS=%_includedir/OpenEXR \
	%nil

ninja-build -v -j %__nprocs -C %_cmake__builddir

%if_with docs
pushd doc/doxygen
doxygen -u Doxyfile
doxygen
popd
%endif

%install
%cmake_install

%files
%_bindir/*
%_desktopdir/%name.desktop
%_iconsdir/hicolor/scalable/apps/%name.svg
%_iconsdir/hicolor/symbolic/apps/%name-symbolic.svg
%_datadir/%name/
%if_with hip
%exclude %_datadir/%name/*/%kern_dir/kernel_gfx*.fatbin*
%endif
%if_with hiprt
%exclude %_datadir/%name/*/%kern_dir/kernel_rt_gfx.hipfb*
%endif
%if_with cuda
%exclude %_datadir/%name/*/%kern_dir/kernel_compute*.ptx*
%exclude %_datadir/%name/*/%kern_dir/kernel_sm_*.cubin*
%endif
%_datadir/metainfo/*.metainfo.xml
%_defaultdocdir/%name/
%_man1dir/%name.1*

%if_with hip
%files cycles-hip-kernels
%_datadir/%name/*/%kern_dir/kernel_gfx*.fatbin*
%endif

%if_with hiprt
%files cycles-hiprt-kernels
%_datadir/%name/*/%kern_dir/kernel_rt_gfx.hipfb*
%endif

%if_with cuda
%files cycles-cuda-kernels
%_datadir/%name/*/%kern_dir/kernel_compute*.ptx*
%_datadir/%name/*/%kern_dir/kernel_sm_*.cubin*
%endif

%if_with docs
%files doc
%doc doc/doxygen/html
%endif

%changelog
