%define xdg_name com.raggesilver.BlackBox
%define _name blackbox

Name: blackbox-terminal
Version: 0.14.0
Release: alt9.git53be998

Summary: A beautiful GTK 4 terminal
License: GPL-3.0
Group: Terminals

Url: https://gitlab.gnome.org/raggesilver/blackbox
Source: %name-%version.tar
Patch1: blackbox-0.14.0-alt-xvt-compatibility.patch
Patch2: blackbox-0.14.0-alt-gio-print.patch
Packager: Vladimir Didenko <cow@altlinux.org>

Provides: xvt
Provides: x-terminal-emulator
# Executable file name conflict
Conflicts: blackbox

%define vte_ver 0.69.0

Requires(pre): libvte3 >= %vte_ver
Requires: dconf

BuildRequires(pre): rpm-macros-meson rpm-build-gnome rpm-macros-alternatives
BuildRequires: meson
BuildRequires: vala
BuildRequires: libgio-devel
BuildRequires: libgtk4-devel
BuildRequires: libvte3-devel >= %vte_ver
BuildRequires: libadwaita-devel
BuildRequires: libmarblepq-vala
BuildRequires: libpcre2-devel libxml2-devel
BuildRequires: librsvg-devel
BuildRequires: libjson-glib-devel
BuildRequires: libgraphene-devel
BuildRequires: libgee0.8-devel

%description
A beautiful GTK 4 terminal.

%prep
%setup
%autopatch -p1

%build
%meson -Dblackbox_is_flatpak=false -Ddevel=false
%meson_build

%install
%meson_install

# alternatives (gnome-terminal -- 39)
mkdir -p %buildroot%_altdir
cat >%buildroot%_altdir/%_name <<EOF
%_bindir/xvt	%_bindir/%_name	38
%_bindir/x-terminal-emulator	%_bindir/%_name	38
EOF

%find_lang %_name

%files -f %_name.lang
%doc COPYING README.md
%_bindir/%_name
%_altdir/%_name
%_datadir/%_name
%_datadir/metainfo/%xdg_name.metainfo.xml
%_desktopdir/%xdg_name.desktop
%_datadir/glib-2.0/schemas/*
%_iconsdir/hicolor/*/actions/*.svg
%_iconsdir/hicolor/*/apps/*.svg

%changelog
