Name: bitcoin
Version: 30.0
Release: alt1

Summary: peer-to-peer network based anonymous digital currency
License: MIT
Group: Networking/Other

Url: http://www.bitcoin.org/
Source: %name-%version.tar
Patch0: %name-%version-%release.patch

BuildRequires: boost-filesystem-devel boost-interprocess-devel boost-program_options-devel boost-signals-devel boost-asio-devel
BuildRequires: gcc-c++ libevent-devel libprotobuf-devel libqrencode-devel libsqlite3-devel
BuildRequires: libssl-devel protobuf-compiler python3-dev qt6-base-devel qt6-tools-devel capnproto-devel
BuildRequires: cmake

%description
Q. What is Bitcoin?
A. Bitcoin is a peer-to-peer currency. Peer-to-peer means that no
central authority issues new money or tracks transactions. These tasks
are managed collectively by the network.

Q. How does Bitcoin work?
A. Bitcoin utilises public-key cryptography. A coin contains the owner's
public key. When a coin is transferred from user A to user B, A adds B's
public key to the coin, and the coin is signed using A's private key. B
now owns the coin and can transfer it further. A is prevented from
transferring the already spent coin to other users because a public list
of all previous transactions is collectively maintained by the network.
Before each transaction the coin's validity will be checked.

%prep
%setup
%patch0 -p1

%build
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

%cmake \
	-DBUILD_GUI=ON \
	-DBUILD_DAEMON=ON \
	-DBUILD_CLI=ON \
	-DBUILD_TESTS=OFF \
	-DWITH_BDB=OFF

%cmake_build

%install
%cmake_install

%pre
rm -f %_bindir/%name

%files
%_bindir/%{name}*
/usr/libexec/*
%_mandir/man1/bitcoin*.1.*
%doc doc/*

%changelog
