# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,lint=relaxed

Name: bin-github
Version: 0.24.1
Release: alt1
Summary: Binaries manager for GitHub (and Docker) releases
License: MIT
Group: System/Configuration/Packaging
Url: https://github.com/marcosnils/bin
Obsoletes: bin-marcosnils < %EVR
Provides: bin-marcosnils = %EVR

Source: %name-%version.tar
BuildRequires: golang

%description
Install and manage upstream static binary executables downloaded from
different sources (mostly from GitHub or Docker registry).

%prep
%setup

%build
%ifnarch %ix86 armh riscv64 loongarch64
export CGO_ENABLED=0
%endif
go build -v -buildmode=pie -ldflags \
	"-X main.version=%version-%release
	 -X main.date=$(date -I)
	 -X main.builtBy=ALT" .

%install
install -Dp bin -t %buildroot%_bindir

%check
./bin --help
./bin --version
./bin --version |& grep -Fx 'bin version %version-%release'
go test -v ./...

%files
%_bindir/bin

%changelog
