%define _unpackaged_files_terminate_build 1

%define _libexecdir %_prefix/libexec

Name: ayatana-indicator-bluetooth
Version: 24.5.0
Release: alt2

Summary: Ayatana Indicator for managing Bluetooth devices
License: GPLv3
Group: Graphical desktop/Other
Url: https://github.com/AyatanaIndicators/ayatana-indicator-bluetooth

Source: %name-%version.tar

# sync with version 24.5.0-3 from Debian unstable
Patch: %name-%version-%release.patch

ExcludeArch: ppc64le

BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-macros-systemd

BuildRequires: ayatana-cmake-modules
BuildRequires: ayatana-indicator-common
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: intltool
BuildRequires: libayatana-common-devel
BuildRequires: libblkid-devel
BuildRequires: libmount-devel
BuildRequires: libpcre2-devel
BuildRequires: libpcre-devel
BuildRequires: libselinux-devel
BuildRequires: libsystemd-devel
BuildRequires: vala-tools
BuildRequires: zlib-devel

Requires: ayatana-indicator-common
Requires: blueman
Requires: bluez
Requires: gobject-introspection
Requires: mate-control-center

%description
This Ayatana Indicator exposes bluetooth functionality via the
system indicator API and provides fast user controls for
Bluetooth devices.

%prep
%setup
%patch -p1

%build
%cmake \
  -Denable_tests=Off
%cmake_build

%install
%cmake_install

# these translations are ignored by %%find_lang
rm -fv %buildroot%_datadir/locale/it_CARES/LC_MESSAGES/%name.mo
rm -fv %buildroot%_datadir/locale/zh_LATN@pinyin/LC_MESSAGES/%name.mo

%find_lang %name

%post
%systemd_user_post %name.service

%preun
%systemd_user_preun %name.service

%postun
%systemd_user_postun %name.service

%files -f %name.lang
%doc COPYING AUTHORS INSTALL.md NEWS README.md
%config %_sysconfdir/xdg/autostart/%name.desktop
%dir %_libexecdir/%name/
%_libexecdir/%name/%{name}-service
%_datadir/glib-2.0/schemas/org.ayatana.indicator.bluetooth.gschema.xml
%_datadir/ayatana/indicators/org.ayatana.indicator.bluetooth
%_userunitdir/%name.service

%changelog
