# Ensure no unpackaged files
%global _unpackaged_files_terminate_build 1

# Stable docs path across the versions
%define _customdocdir %_defaultdocdir/%name

# wc-config --cflags to add -I/usr/include/wx-3.1
# wx-config --libs: https://github.com/audacity/audacity/issues/552
# libmp3lame: https://github.com/audacity/audacity/issues/2166
%add_optflags %(wx-config --cflags || :) -DDISABLE_DYNAMIC_LOADING_LAME=1

%ifarch armh %ix86
%add_optflags -DPFFFT_SIMD_DISABLE=1
%endif

%define add_libs %(wx-config --libs || :) -lmp3lame

Name: audacity
Version: 3.7.5
Release: alt1

Summary: Cross-platform audio editor
Summary(ru_RU.UTF-8): Кроссплатформенный звуковой редактор
License: GPL
Group: Sound

Url: https://www.audacityteam.org
Vcs: https://github.com/audacity/audacity

# https://github.com/audacity/audacity/releases
Source0: %name-sources-%version.tar
Source1: %name-manual-%version.tar
# XXX
Source2: loffice-libcxx-wrapper.sh
Source3: README.ALT

# Patch0001: 0001-Desktop-file-fix-exec-command.patch
Patch0002: 0002-Use-home-directory-for-temp-dir-instead-of-var-tmp-t.patch
Patch0003: 0003-Fix-building-with-system-sbsms.patch
Patch0005: 0005-Fix-lv2-external-gui.patch
Patch0006: 0006-Find-modules-in-lib64.patch
Patch0007: 0007-Manual-document-session-path.patch
Patch0008: 0008-Fix-release-build-warning.patch

Source2000: audacity-e2k.patch

BuildRequires: gcc-c++
BuildRequires: cmake
# -Daudacity_conan_enabled=Off is a temporary workaround according to
# https://github.com/audacity/audacity/pull/1030
#BuildRequires: conan
BuildRequires: chrpath
BuildRequires: gettext-devel
BuildRequires: ImageMagick-tools
BuildRequires: ladspa_sdk
BuildRequires: liblame-devel
BuildRequires: libportmidi-devel
# Requires wxWidgets built without STL
BuildRequires: libwxGTK3.2-devel
BuildRequires: zip
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(expat)
BuildRequires: pkgconfig(fftw3)
BuildRequires: pkgconfig(flac++)
BuildRequires: pkgconfig(id3tag)
BuildRequires: pkgconfig(flac)
BuildRequires: pkgconfig(fftw3)
BuildRequires: pkgconfig(gtk+-3.0)
BuildRequires: pkgconfig(glib-2.0)
BuildRequires: pkgconfig(jack)
BuildRequires: pkgconfig(libavformat)
BuildRequires: pkgconfig(lilv-0)
BuildRequires: pkgconfig(libjpeg)
BuildRequires: pkgconfig(libturbojpeg)
BuildRequires: pkgconfig(lv2)
BuildRequires: pkgconfig(mad)
BuildRequires: pkgconfig(ogg)
BuildRequires: pkgconfig(opus)
BuildRequires: pkgconfig(opusfile)
BuildRequires: pkgconfig(portaudio-2.0)
BuildRequires: pkgconfig(RapidJSON)
BuildRequires: pkgconfig(samplerate)
BuildRequires: pkgconfig(sbsms)
BuildRequires: pkgconfig(sndfile)
BuildRequires: pkgconfig(soundtouch)
BuildRequires: pkgconfig(soxr)
BuildRequires: pkgconfig(speex)
BuildRequires: pkgconfig(sqlite3)
BuildRequires: pkgconfig(suil-0)
BuildRequires: pkgconfig(twolame)
BuildRequires: pkgconfig(uuid)
BuildRequires: pkgconfig(udev)
BuildRequires: pkgconfig(vamp-hostsdk)
BuildRequires: pkgconfig(vorbis)
BuildRequires: pkgconfig(vorbisenc)
BuildRequires: pkgconfig(vorbisfile)
BuildRequires: pkgconfig(wavpack)
BuildRequires: pkgconfig(zlib)
# %%autopatch macro appeared in 4.0.4-alt133
BuildRequires: rpm-build >= 4.0.4-alt133

# Dummy dependency from dlopen()'ed library, without ABI tracking, track at least soname
# https://github.com/audacity/audacity/issues/2161
# This makes sure that the latest ffmpeg libraries Audacity supports
# are installed, and won't be removed from the repository without
# us noticing that.
%if "%_lib" == "lib64"
%define soname_suffix ()(64bit)
%else
%define soname_suffix %nil
%endif
Requires: libavformat.so.61%soname_suffix
Requires: libavcodec.so.61%soname_suffix
Requires: libavutil.so.59%soname_suffix

%description
Audacity is a program that lets you manipulate digital audio waveforms.
It imports many sound file formats, including WAV, AIFF, AU, IRCAM,
MP3, and Ogg Vorbis. It supports all common editing operations such
as Cut, Copy, and Paste, plus it will mix tracks and let you apply
plug-in effects to any part of a sound.

%description -l ru_RU.UTF-8
Audacity - программа, которая дает возможность обрабатывать звукозаписи
в цифровом виде. Она может импортировать множество аудиоформатов, в т.ч.
WAV, AIFF, AU, IRCAM, MP3, Ogg Vorbis, и поддерживает все основные
операции редактирования, такие как Вырезать, Скопировать, Вставить,
а также возможность микширования дорожек и применения эффектов,
предоставляемых подключаемыми модулями, к любой части звука.

%package manual
Summary: Audacity manual (offline install)
Group: Documentation
BuildArch: noarch

%description manual
Audacity Manual can be installed locally if preferred, or accessed
on-line if internet connection is available.

For the most up to date manual content, use the on-line manual.

%prep
%setup -n %name-sources-%version
mkdir manual
tar -xf %SOURCE1 --strip-components=1 -C manual
%autopatch -p1
cp %SOURCE3 .

sed -i 's/"lv2 >= .* >= 0.10.6"//' cmake-proxies/CMakeLists.txt
%add_optflags -isystem /usr/include/suil-0 -lsuil-0

%ifarch %e2k
# EDG frontend bug workaround
sed -i "/std::initializer_list/s/static//" src/prefs/GUIPrefs.cpp
sed -i "s/.*\[ upstream, downstream \].*/\
for (auto \&fix : mDecoratedSources) {\
auto \&upstream = fix.upstream; auto \&downstream = fix.downstream;/" \
  libraries/lib-mixer/Mix.cpp
sed -i "s/mAdjustPolicy{}/mAdjustPolicy/" \
  src/tracks/playabletrack/wavetrack/ui/WaveClipAdjustBorderHandle.h
patch -p2 -i %SOURCE2000
%endif

%build
export ADD_LIBS="%add_libs"
install -m0755 %SOURCE2 ./g++
export CXX="$PWD/g++"
export CC="$(command -v gcc)"

# disable assertions checked via wxASSERT
%add_optflags -DwxDEBUG_LEVEL=0

%cmake \
  -DCMAKE_SKIP_INSTALL_RPATH:BOOL=OFF \
  -DCMAKE_INSTALL_RPATH:PATH='$ORIGIN/../' \
  -DCMAKE_BUILD_WITH_INSTALL_RPATH:BOOL=On \
  -DCMAKE_BUILD_TYPE=RelWithDebInfo \
  -Daudacity_lib_preference:STRING=system \
  -Daudacity_has_networking=no \
  -Daudacity_conan_enabled=Off \
  -Daudacity_has_vst3=Off \
  -Daudacity_obey_system_dependencies=On \
  -Daudacity_use_ffmpeg:STRING=loaded \
  -Daudacity_use_libavcodec:STRING=system \
  -Daudacity_use_libavformat:STRING=system \
  -Daudacity_use_libavutil:STRING=system \
  -Daudacity_use_libmp3lame:STRING=system \
  -Daudacity_use_libflac:STRING=system \
  -Daudacity_use_libid3tag:STRING=system \
  -Daudacity_use_libsndfile:STRING=system \
  -Daudacity_use_libsoxr:STRING=system \
  -Daudacity_use_libtwolame:STRING=system \
  -Daudacity_use_libuuid:STRING=system \
  -Daudacity_use_libvamp:STRING=system \
  -Daudacity_use_libvorbis:STRING=system \
  -Daudacity_use_lv2:STRING=system \
  -Daudacity_use_sbsms:STRING=system \
  -Daudacity_use_soundtouch:STRING=system \
  -Daudacity_use_portaudio:STRING=system \
  -Daudacity_use_portsmf:STRING=local \
  -Daudacity_use_midi:STRING=system \
  -DAUDACITY_BUILD_LEVEL=2 \
  -DAUDACITY_SUFFIX:STRING=""

%cmake_build

%install
%cmakeinstall_std
cp -a manual/manual %buildroot%_datadir/%name/help
rm -rf %buildroot%_defaultdocdir/%name
rm -rf %buildroot%_datadir/%name/include
# Remove a helper script that runs audacity in GitHub CI builds
rm -rf %buildroot%_prefix/%name

# Remove absolute RPATHs
# https://github.com/audacity/audacity/pull/1030#issuecomment-873630620
# https://github.com/audacity/audacity/issues/2165
setrpath="chrpath -r"
$setrpath '$ORIGIN/../%_lib/audacity' %buildroot%_bindir/audacity
for lib in %buildroot%_libdir/audacity/*.so; do
  $setrpath '$ORIGIN' "$lib"
done
for lib in %buildroot%_libdir/audacity/modules/*.so; do
  $setrpath '$ORIGIN/../' "$lib"
done

%find_lang %name

%check
# upstream seems to assume statically linking bundled libsbsms,
# verify that system one is used
objdump -x -j .dynamic %buildroot/%_libdir/audacity/lib-builtin-effects.so | grep -Fw NEEDED | grep sbsms

# mp3lame can be either dlopen'ed or linked explicitly,
# ensure that a system library is linked explicitly
objdump -x -j .dynamic %buildroot/%_libdir/audacity/modules/mod-mp3.so | grep -Fw NEEDED | grep libmp3lame

# https://github.com/audacity/audacity/issues/2161
# [...] | grep -q libavcodec

%files -f %name.lang
%doc CHANGELOG.txt CODE_OF_CONDUCT.md CONTRIBUTING.md LICENSE.txt README.md README.ALT
%_bindir/audacity
%_libdir/audacity
%_mandir/man?/*
%_iconsdir/*/*/apps/%name.svg
%_iconsdir/hicolor/*/%name.png
%dir %_datadir/%name
%exclude %_datadir/%name/help
%_datadir/%name/*
%_datadir/applications/%name.desktop
%_datadir/mime/packages/%name.xml
%_datadir/metainfo/%name.appdata.xml
%_datadir/icons/hicolor/*/apps/%name.*
%_pixmapsdir/*.xpm

%files manual
%dir %_datadir/%name
%_datadir/%name/help

%changelog
