Name: attr
Version: 2.5.1
Release: alt2

Summary: Utilities for managing filesystem extended attributes
License: GPLv2+
Group: File tools
Url: https://savannah.nongnu.org/projects/attr
# git://git.altlinux.org/gears/a/attr.git
Source: %name-%version-%release.tar

Requires: lib%name = %version-%release

%define _libexecdir %_libdir
%def_enable static

%description
A set of tools for manipulating extended attributes on filesystem
objects, in particular getfattr(1) and setfattr(1).
An attr(1) command is also provided which is largely compatible
with the SGI IRIX tool of the same name.

%package -n lib%name
Summary: Dynamic library for extended attribute support
License: LGPLv2+
Group: System/Libraries

%package -n lib%name-devel
Summary: Extended attribute development library and headers files
License: LGPLv2+
Group: Development/C
Requires: lib%name = %version-%release

%package -n lib%name-devel-static
Summary: Static library for extended attribute support
License: LGPLv2+
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name
This package contains the library needed to run programs dynamically
linked with lib%name.

%description -n lib%name-devel
This package contains the development library and header files
needed to develop programs which make use of extended attributes.
For Linux programs, the documented system call API is the
recommended interface, but an SGI IRIX compatibility interface
is also provided.

Currently only ext2, ext3, JFS and XFS support extended attributes.
The SGI IRIX compatibility API built above the Linux system calls is
used by programs such as xfsdump(8), xfsrestore(8) and xfs_fsr(8).

%description -n lib%name-devel-static
This package contains the static library needed to develop
statically linked programs which make use of extended attributes.

%prep
%setup

%build
%global optflags_lto %optflags_lto -ffat-lto-objects
./autogen.sh
%configure %{subst_enable static}
%make_build V=1

%install
%makeinstall_std dist_doc_DATA='README doc/CHANGES'

# Relocate shared libraries from %_libdir/ to /%_lib/.
mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/*.so; do
	t=$(readlink -v "$f")
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

%find_lang %name
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%check
if ./setfattr -n user.name -v value .; then
	%make_build -k check
else
	echo 'xattrs are probably not supported by the file system'
	stat -f .
fi

%files -f %name.lang
%_bindir/*
%_man1dir/*
%_docdir/%name/

%files -n lib%name
%config(noreplace) %_sysconfdir/xattr.conf
/%_lib/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_man3dir/*
%_includedir/*
%_pkgconfigdir/*.pc

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
