Group: Development/Tools
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           atasm
Version:        1.30
Release:        alt1_2
Summary:        6502 cross-assembler

License:        GPL-2.0-or-later
URL:            https://github.com/CycoPH/atasm
Source0:        https://github.com/CycoPH/atasm/archive/V%{version}.tar.gz#/%{name}-%{version}.tar.gz

BuildRequires:  gcc
BuildRequires:  zlib-devel
Source44: import.info


%description
ATasm is a 6502 command-line cross-assembler that is compatible with the
original Mac/65 macro-assembler released by OSS software.  Code
development can now be performed using "modern" editors and compiles
with lightning speed.


%prep
%setup -q



%build
pushd src
%make_build CFLAGS="%{optflags} -DZLIB_CAPABLE -DUNIX" L="%{build_ldflags} -lz -lm"
sed -e 's|\%\%DOCDIR\%\%|%{?_pkgdocdir}%{!?_pkgdocdir:%{_docdir}/%{name}-%{version}}|g' %{name}.1.in > %{name}.1
popd


%install
mkdir -p %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{_mandir}/man1

pushd src
install -p -m 755 %{name} %{buildroot}%{_bindir}
install -p -m 644 %{name}.1 %{buildroot}%{_mandir}/man1
popd


%check
pushd tests
make test
popd


%files
%doc --no-dereference LICENSE
%doc VERSION.TXT README.md docs/atasm.blurb docs/atasm.pdf
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*


%changelog
