Name:     asusctl
Version:  6.1.12
Release:  alt2

Summary:  A control daemon, CLI tools, and a collection of crates for interacting with ASUS ROG laptops 
License:  MPL-2.0
Group:    System/Configuration/Hardware
Url:      https://asus-linux.org
Vcs:      https://gitlab.com/asus-linux/asusctl

ExclusiveArch: x86_64

Packager: Hihin Ruslan <ruslandh@altlinux.ru>

Source:  %name-%version.tar
Source1: README.ru
Source2: vendor_asusctl-%version.tar
Source3: cargo_src.tar
Source4: update-vendor.sh
Source5: config.toml

BuildRequires(pre): rpm-macros-rust rpm-macros-systemd >= 5
BuildRequires(pre): rust-cargo 

# Automatically added by buildreq on Sat Oct 26 2024
# optimized out: ca-trust glibc-kernheaders-generic glibc-kernheaders-x86 libgpg-error libp11-kit libsasl2-3 libudev-devel libwayland-server llvm17.0-libs pkg-config python3 python3-base python3-dev rust rust-cargo sh5
BuildRequires: libgbm-devel libinput-devel libseat1-devel libxkbcommon-devel python3-module-setuptools python3-module-zope

BuildRequires: clang libclang20

Buildrequires: libxkbcommon-x11-devel cargo-vendor-filterer

# For Version 6.x BuildRequires: libgbm-devel libinput-devel libseat1-devel libxkbcommon-devel python3-module-setuptools python3-module-zope rust-cargo

BuildRequires: pkgconfig(gio-2.0)
BuildRequires: pkgconfig(cairo-gobject)
BuildRequires: pkgconfig(atk)
BuildRequires: pkgconfig(gdk-pixbuf-2.0)
BuildRequires: pkgconfig(pango)
BuildRequires: pkgconfig(gdk-3.0)

BuildRequires:  pkgconfig(expat)
BuildRequires:  pkgconfig(gbm)
BuildRequires:  pkgconfig(dbus-1)
BuildRequires:  pkgconfig(libdrm)
BuildRequires:  pkgconfig(libinput)
BuildRequires:  pkgconfig(libseat)
BuildRequires:  pkgconfig(libudev)
BuildRequires:  pkgconfig(xkbcommon)
BuildRequires:  pkgconfig(libzstd)
BuildRequires:  pkgconfig(gtk+-3.0)

%description
asusd is a utility for Linux to control many aspects of various ASUS laptops
but can also be used with non-asus laptops with reduced features.

Asusctl for ASUS ROG https://asus-linux.org


%description -l ru_RU.utf8
asusd - утилита для Linux, позволяющая управлять многими аспектами различных ноутбуков ASUS.
но также может использоваться с ноутбуками сторонних производителей с ограниченными возможностями.
подробнее  https://asus-linux.org

%package rog-gui
Summary: An experimental GUI for %name
Group:    System/Configuration/Hardware
Requires: %name = %EVR

%description rog-gui
A one-stop-shop GUI tool for asusd/asusctl. It aims to provide most controls,
a notification service, and ability to run in the background.

%global rustflags -Clink-arg=-Wl,-z,relro,-z,now

%prep
%setup -a2 -a3

install -m755 %SOURCE4 .
install -D -m644 %SOURCE5 .cargo/config.toml
sed -i s@/usr/bin/sleep@/bin/sleep@ ./data/asusd-user.service

%build
export RUSTFLAGS="%rustflags"
RUST_BACKTRACE=1 

export CARGO_HOME=%_builddir/%name-%version/cargo_src

# ./update-vendor.sh

%rust_build --features "rog-control-center/x11"

#    export RUSTFLAGS="${RUSTFLAGS} -g" 
#    cargo build --release -j${NPROCS:-24}


%install
export RUSTFLAGS="%rustflags"

install -m644 %SOURCE1 %_builddir/%name-%version
%makeinstall_std

mkdir -p %buildroot/%_unitdir
mkdir -p %buildroot/%_udevrulesdir
install data/asusd.service %buildroot/%_unitdir/asusd.service

%files
%_bindir/*
%exclude %_bindir/rog-control-center
%doc README.ru *.md
%_datadir/asusd
%_datadir/dbus-1/system.d/*.conf
%_udevrulesdir/*.rules

%_unitdir/*.service

%_user_unitdir/*.service
%_iconsdir/hicolor/512x512/apps/*
%exclude %_iconsdir/hicolor/512x512/apps/rog-control-center.png
%_iconsdir/hicolor/scalable/*

%files rog-gui
%_bindir/rog-control-center
%_desktopdir/rog-control-center.desktop

%_iconsdir/hicolor/512x512/apps/rog-control-center.png
%_datadir/rog-gui/*

%changelog
