# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ perl(Date/Format.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %_var

%global commit 28d9b8d6df708024af5227c551673fdb2519f5bf
%global shortcommit %(c=%commit; echo ${c:0:7})

Name: asio
Version: 1.36.0
Release: alt1

Summary: A cross-platform C++ library for network programming
License: Boost Software License
Group: Development/C++

Url: https://think-async.com
Source: %name-%version.tar.bz2
Packager: Ilya Mashkin <oddity@altlinux.ru>

BuildRequires: autoconf
BuildRequires: automake
BuildRequires: libssl-devel gcc gcc-c++
BuildRequires: boost-devel boost-devel-headers boost-python-headers
%ifnarch %e2k
BuildRequires: boost-coroutine-devel
%endif
Source44: import.info

%description
The asio package contains a cross-platform C++ library for network programming
that provides developers with a consistent asynchronous I/O model using a
modern C++ approach.

%package devel
Summary: Header files for asio
Group: Development/Other

%description devel
Header files you can use to develop applications with asio.

The asio package contains a cross-platform C++ library for network programming
that provides developers with a consistent asynchronous I/O model using a
modern C++ approach.

%prep
%setup

%ifarch %e2k
%add_optflags -Wno-unused-variable
sed -i "s/AM_CXXFLAGS = /&-std=c++11 /" src/examples/cpp11/Makefile.in
# EDG frontend can't handle such C++ code
echo "" > src/examples/cpp11/type_erasure/sleep.cpp
echo "" > src/examples/cpp11/type_erasure/stdin_line_reader.cpp
echo "int main() {}" > src/examples/cpp11/type_erasure/main.cpp
echo "int main() {}" > src/examples/cpp14/executors/priority_scheduler.cpp
echo "int main() {}" > src/examples/cpp14/executors/pipeline.cpp
echo "int main() {}" > src/examples/cpp14/executors/actor.cpp
echo "int main() {}" > src/examples/cpp14/operations/composed_4.cpp
echo "int main() {}" > src/examples/cpp14/operations/composed_7.cpp
echo "int main() {}" > src/examples/cpp14/operations/composed_8.cpp
%endif

%build
#./autogen.sh
%configure
%make_build

%install
%makeinstall_std

%files devel
%doc doc/*
%doc LICENSE*
%dir %_includedir/asio
%_includedir/asio/*
%_includedir/asio.hpp
%_datadir/pkgconfig/asio.pc

%changelog
