%ifarch %ix86
%def_without check
%else
%def_with check
%endif

%define soname 14
%define _unpackaged_files_terminate_build 1
Name:           armadillo
Version:        14.2.2
Release:        alt1
Summary:        Fast C++ matrix library with syntax similar to MATLAB and Octave
Group: Sciences/Mathematics
License:        Apache-2.0
URL:            https://arma.sourceforge.net/
VCS: https://gitlab.com/conradsnicta/armadillo-code
Source:         %{name}-%{version}.tar
BuildRequires:  gcc-c++
BuildRequires:  ctest cmake
BuildRequires:  libarpack-ng-devel
BuildRequires:  hdf5-tools libhdf5-devel
BuildRequires:  libsuperlu-devel
BuildRequires:  libflexiblas-devel
BuildRequires:  liblapack-devel

%description
Armadillo is a C++ linear algebra library (matrix maths)
aiming towards a good balance between speed and ease of use.
Integer, floating point and complex numbers are supported,
as well as a subset of trigonometric and statistics functions.
Various matrix decompositions are provided through optional
integration with LAPACK and ATLAS libraries.
A delayed evaluation approach is employed (during compile time)
to combine several operations into one and reduce (or eliminate)
the need for temporaries. This is accomplished through recursive
templates and template meta-programming.
This library is useful if C++ has been decided as the language
of choice (due to speed and/or integration capabilities), rather
than another language like Matlab or Octave.

%package -n libarmadillo%soname
Summary:        Shared library for the armadillo library
Group:          System/Libraries

%description -n libarmadillo%soname
Armadillo is a C++ linear algebra library (matrix maths)
aiming towards a good balance between speed and ease of use.
Integer, floating point and complex numbers are supported,
as well as a subset of trigonometric and statistics functions.
Various matrix decompositions are provided through optional
integration with LAPACK and ATLAS libraries.
A delayed evaluation approach is employed (during compile time)
to combine several operations into one and reduce (or eliminate)
the need for temporaries. This is accomplished through recursive
templates and template meta-programming.
This library is useful if C++ has been decided as the language
of choice (due to speed and/or integration capabilities), rather
than another language like Matlab or Octave.

This package contains the shared library.


%package -n libarmadillo-devel
Group: Sciences/Mathematics
Summary:        Development headers and documentation for the Armadillo C++ library
Requires:       libarmadillo%soname = %EVR
Requires:       hdf5-tools
Provides: %name-devel = %EVR


%description -n libarmadillo-devel
This package contains files necessary for development using the
Armadillo C++ library. It contains header files, example programs,
and user documentation (API reference guide).


%prep
%setup -q

sed -i 's/\r//' README.md
rm -rf examples/*win64*

%build
%cmake -DALLOW_FLEXIBLAS_LINUX=ON
%cmake_build


%install
%cmake_install


%check
%cmake -DALLOW_FLEXIBLAS_LINUX=ON -DBUILD_SMOKE_TEST=ON
%cmake_build
%ctest


%files -n libarmadillo%soname
%doc --no-dereference LICENSE.txt NOTICE.txt
%_libdir/libarmadillo.so.%soname
%_libdir/libarmadillo.so.%{soname}.*

%files -n libarmadillo-devel
%{_libdir}/libarmadillo.so
%{_libdir}/pkgconfig/%{name}.pc
%{_includedir}/armadillo
%{_includedir}/armadillo_bits/
%{_datadir}/Armadillo/
%doc README.md
%doc index.html
%doc docs.html
%doc examples
%doc armadillo_icon.png
%doc mex_interface
%doc armadillo_nicta_2010.pdf
%doc armadillo_rcpp_2014.pdf
%doc armadillo_joss_2016.pdf
%doc armadillo_spcs_2017.pdf
%doc armadillo_lncs_2018.pdf
%doc armadillo_solver_2020.pdf
%doc armadillo_mca_2019.pdf


%changelog
