Name: apitrace
Version: 12.0
Release: alt1

Summary: Tools for tracing OpenGL

License: MIT
Group: Graphics
Url: http://apitrace.github.io/

# Source-url: https://github.com/apitrace/apitrace/archive/refs/tags/%version.tar.gz
Source: %name-%version.tar
Source1: qapitrace.desktop
Source2: qapitrace.appdata.xml

# fix building with CMakeLists.txt from subdirectory
Patch1: apitrace-11.1-disabled-check-subdirectory.patch

# internal
%add_python3_req_skip highlight

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake ctest
BuildRequires: libpng-devel libbrotli-devel
BuildRequires: libsnappy-devel
BuildRequires: desktop-file-utils
#BuildRequires: libappstream-glib
BuildRequires: libgtest-devel
BuildRequires: libdwarf-devel libproc2-devel
BuildRequires: libbacktrace-devel

# for gui tools
BuildRequires: libX11-devel
BuildRequires: qt5-base-devel

BuildRequires(pre): rpm-build-python3

%description
apitrace consists of a set of tools to:
 * trace OpenGL and OpenGL ES  APIs calls to a file;
 * replay OpenGL and OpenGL ES calls from a file
 * inspect OpenGL state at any call while retracing
 * visualize and edit trace files

%package -n lib%name
Summary: Libraries used by apitrace
Requires: %name = %version-%release
Group: Graphics

%description -n lib%name
Libraries used by apitrace

%package gui
Summary: Graphical frontend for apitrace
Requires: %name = %version-%release
Group: Graphics

%description gui
This package contains qapitrace, the Graphical frontend for apitrace.

%prep
%setup
# fix WRAPPER_DIR
%__subst "s|dpkg-architecture|no-dpkg-architecture|" CMakeLists.txt
%patch1 -p2

# https://bugzilla.redhat.com/show_bug.cgi?id=1507659
# Remove bundled libraries, except khronos headers, md5, crc32c and CMakeLists.txt file
rm -rf `ls -1d thirdparty/* | grep -Ev "(khronos|md5|crc32c|CMakeLists.txt)"`

# Fix spurious-executable-perm
chmod -x retrace/glretrace_main.cpp

sed -i '1i #!/usr/bin/env python3' scripts/highlight.py

%build
%cmake_insource -DENABLE_STATIC_SNAPPY=OFF -DENABLE_STATIC_LIBSTDCXX=OFF -DENABLE_STATIC_LIBGCC=OFF
%make_build

%install
%makeinstall_std

# Install doc through %%doc
rm -rf %buildroot%_docdir/

# Install desktop file
desktop-file-install --dir=%buildroot%_desktopdir/ %SOURCE1

# Install appdata file
install -Dpm 0644 %SOURCE2 %buildroot%_datadir/appdata/qapitrace.appdata.xml
#%_bindir/appstream-util validate-relax --nonet %buildroot%_datadir/appdata/qapitrace.appdata.xml

# highlight.py is not a script
#chmod 0644 %buildroot%_libdir/%name/scripts/highlight.py

%check
make check

%files
%doc LICENSE
%doc README.markdown docs/*
%_bindir/apitrace
%_bindir/eglretrace
%_bindir/glretrace
%_bindir/gltrim

%_libdir/%name/

%files gui
%_bindir/qapitrace
%_desktopdir/qapitrace.desktop
%_datadir/appdata/qapitrace.appdata.xml

%changelog
