%global base_name daemon
%global short_name commons-%{base_name}

Name: apache-commons-daemon
Summary: Defines API to support an alternative invocation mechanism
Version: 1.4.1
Release: alt2
Epoch: 1
License: Apache-2.0
Group: System/Base

URL: https://commons.apache.org/%{base_name}

Source0: https://archive.apache.org/dist/commons/%{base_name}/source/%{short_name}-%{version}-src.tar.gz
Patch33: apache-commons-daemon-1.2.0-e2k.patch
Patch34: apache-commons-daemon-1.2.0-riscv64.patch
Patch35: apache-commons-daemon-1.2.4-loongarch64.patch

BuildRequires: dos2unix
BuildRequires: xmlto
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-17-compat
BuildRequires: maven-local
BuildRequires: mvn(junit:junit)
BuildRequires: mvn(org.apache.commons:commons-parent:pom:)

%description
The scope of this package is to define an API in line with the current
Java Platform APIs to support an alternative invocation mechanism
which could be used instead of the public static void main(String[])
method.  This specification covers the behavior and life cycle of what
we define as Java daemons, or, in other words, non interactive
Java applications.

%package jsvc
Group: System/Base
Summary: Java daemon launcher
Provides: jsvc = %EVR

%description jsvc
Java daemon launcher.

%javadoc_package

%prep
%setup -q -n %{short_name}-%{version}-src
%patch33 -p1
%patch34 -p1
%patch35 -p1

# convert to correct end-of-line format
dos2unix -k -n src/samples/ProcrunServiceInstall.cmd src/samples/ProcrunServiceInstall.cmd.new
rm src/samples/ProcrunServiceInstall.cmd
mv src/samples/ProcrunServiceInstall.cmd.new src/samples/ProcrunServiceInstall.cmd

# build manpage for jsvc
cd src/native/unix
xmlto man man/jsvc.1.xml

%build
# build native jsvc
pushd src/native/unix
#sh support/buildconf.sh
%configure --with-java=$JAVA_HOME
%make_build
popd

# build jars
%mvn_file  : %{short_name} %{name}
%mvn_alias : org.apache.commons:%{short_name}
%mvn_build

%install
# install native jsvc
install -Dpm 755 src/native/unix/jsvc $RPM_BUILD_ROOT%{_bindir}/jsvc
install -Dpm 644 src/native/unix/jsvc.1 $RPM_BUILD_ROOT%{_mandir}/man1/jsvc.1

%mvn_install

%files -f .mfiles
%doc LICENSE.txt PROPOSAL.html NOTICE.txt RELEASE-NOTES.txt src/samples
%doc src/docs/*

%files jsvc
%doc LICENSE.txt NOTICE.txt
%{_bindir}/jsvc
%{_mandir}/man1/jsvc.1*

%changelog
