Name: ansible-lint
Version: 25.9.2
Release: alt1

Summary: Best practices checker for Ansible

Group: System/Libraries
License: GPLv3+
Url: https://github.com/ansible/ansible-lint
Source: %name-%version.tar

BuildArch: noarch
BuildRequires(pre): rpm-macros-python3
BuildRequires: python3-devel >= 3.10
BuildRequires: rpm-build-python3 %pyproject_buildrequires
BuildRequires: python3-module-tox python3-module-pip python3-module-wheel
BuildRequires: python3-module-setuptools >= 65.3.0
BuildRequires: python3-module-setuptools_scm >= 7.0.5
BuildRequires: python3-module-rich >= 12.0.0
BuildRequires: python3-module-ruamel-yaml >= 0.18.5
BuildRequires: python3-module-yamllint >= 1.30.0
BuildRequires: ansible-core >= 2.17.6 python3-module-ansible-compat >= 25.1.3

# for tests
#BuildRequires: python3-module-yaml >= 5.4.1
#BuildRequires: python3-module-pytest >= 7.2.2 python3-module-pytest-xdist >= 2.1.0
#BuildRequires: python3-module-pylint python3-module-mypy python3-module-black
#BuildRequires: python3-module-importlib-metadata
#BuildRequires: python3-module-ansible-collections
#BuildRequires: python3-module-wcmatch

Requires: ansible-core >= 2.17.6
Requires: ansible-compat >= 25.1.3
Requires: python3-module-yamllint

%description
ansible-lint checks playbooks for practices and behavior that could
potentially be improved.

%prep
%setup
echo "ref-names: tag: v%version" > .git_archival.txt

%build
%pyproject_build

%install
%pyproject_install

#%%check
#%%pyproject_run_pytest

%files
%doc README.md examples
%_bindir/%name
%python3_sitelibdir/*

%changelog
