%define _unpackaged_files_terminate_build 1

Name: ananicy-cpp
Version: 1.1.1
Release: alt1

Summary: Rewrite of ananicy in c++ for lower cpu and memory usage

License: GPL-3.0-only
Group: System/Kernel and hardware
Url: https://gitlab.com/ananicy-cpp/ananicy-cpp

# Source-url: https://gitlab.com/ananicy-cpp/ananicy-cpp/-/archive/v%version/v%version.tar.gz
Source: %name-%version.tar

ExcludeArch: i586

BuildRequires(pre): rpm-macros-cmake
BuildRequires: bpftool
BuildRequires: gcc-c++ clang
BuildRequires: cmake
BuildRequires: libfmt-devel
BuildRequires: nlohmann-json-devel
BuildRequires: libbpf-devel
BuildRequires: ninja-build
BuildRequires: libspdlog-devel
BuildRequires: libsystemd-devel
BuildRequires: zlib-devel
BuildRequires: libelf-devel
Requires: ananicy-rules

%description
%summary.

%prep
%setup

%build
%cmake \
    -GNinja \
    -DENABLE_SYSTEMD=ON \
    -DUSE_BPF_PROC_IMPL=ON \
    -DBPF_BUILD_LIBBPF=OFF \
    -DUSE_EXTERNAL_FMTLIB=ON \
    -DUSE_EXTERNAL_JSON=ON \
    -DUSE_EXTERNAL_SPDLOG=ON \
    -DVERSION=%version
%cmake_build --target %name

%install
%cmake_install --component Runtime

%files
%doc LICENSE
%doc README.md
%_bindir/ananicy-cpp
%_unitdir/ananicy-cpp.service

%changelog
