%define _unpackaged_files_terminate_build 1
%def_with legacy
%define alt_name acc

Name: alterator-explorer
Version: 0.1.16
Release: alt1

Summary: Explorer of Alterator applications operating via D-Bus
License: GPLv2+
Group: System/Configuration/Other
URL: https://gitlab.basealt.space/alt/alterator-explorer

Source0: %name-%version.tar

BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-macros-alterator
BuildRequires(pre): rpm-macros-alternatives
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: qt6-base-devel
BuildRequires: qt6-tools-devel
BuildRequires: qt6-base-common
BuildRequires: boost-devel-headers
BuildRequires: libtomlplusplus-devel
BuildRequires: libqtsingleapplication-qt6-devel

# TODO(chernigin): validate interface on build
BuildRequires: alterator-interface-application

%if_without legacy
BuildRequires: ImageMagick-tools
%endif

Requires: alterator-interface-application >= 0.1.1
Requires: alterator-backend-categories >= 0.1.2
Requires: alterator-backend-legacy >= 0.1.2

%if_with legacy
Requires: alterator-standalone >= 7.4.3
Requires: /usr/bin/acc-legacy
Requires: alterator-backend-legacy
%else
# Oldest versions of alterator-standalone don't provides acc-legacy.
# TODO: Add force disable SwitchBack() logic in this case. So,
#       alterator-explorer conflicts with alterator-standalone until this task
#       is not completed.
Conflicts: alterator-standalone >= 7.4.3
%endif

Requires: alterator-manager >= 0.1.25
Requires: alterator-module-executor >= 0.1.14

%description
%summary.

%prep
%setup

%build
%cmake
%cmake_build

%install
%cmakeinstall_std

install -D -m644 setup/%name.desktop \
    %buildroot%_desktopdir/%name.desktop
%if_with legacy
install -d %buildroot/%_altdir
cat > %buildroot/%_altdir/%name <<EOF
%_bindir/%alt_name	%_bindir/%name 50
EOF
echo "NoDisplay=true" >> %buildroot%_desktopdir/%name.desktop
touch %buildroot/%_bindir/%alt_name
%endif

%files
%_datadir/alterator/categories/*
%doc *.md
%_bindir/%name
%_desktopdir/%name.desktop

%if_with legacy
%ghost %_bindir/%alt_name
%config %_altdir/%name
%_bindir/%alt_name
%endif

%changelog
