%define _unpackaged_files_terminate_build 1

Name: alterator-backend-legacy
Version: 0.1.6
Release: alt2

Summary: Alterator manager backends generator for old alterator modules
License: GPLv2+
Group: System/Configuration/Other
URL: https://altlinux.space/alterator/alterator-backend-legacy

Source0: %name-%version.tar

BuildRequires(pre): rpm-macros-alterator
BuildRequires(pre): rpm-macros-cmake
BuildRequires: python3-devel
BuildRequires: cmake
BuildRequires: cmake-modules
BuildRequires: gcc-c++
BuildRequires: qt6-base-common qt6-base-devel qt6-tools-devel

Requires: alterator-manager >= 0.1.28
Requires: alterator-module-executor >= 0.1.14
Requires: alterator-interface-legacy alterator-application-legacy
Requires: alterator-standalone
Requires: python3
Requires: bash

%package -n alterator-interface-legacy
Summary: Interface for old alterator modules
Group: System/Configuration/Other
Version: 0.1.1
Release: alt1

%package -n alterator-application-legacy
Summary: Runner for old alterator modules
Group: System/Configuration/Other
Version: 0.1.2
Release: alt1

%description
Alterator manager backends generator for old alterator modules.

%description -n alterator-interface-legacy
Interface for old alterator modules.

%description -n alterator-application-legacy
Runner for old alterator modules.

%prep
%setup

%build
%cmake
%cmake_build

%install
%cmakeinstall_std

mkdir -p %buildroot%_libexecdir/%name
mkdir -p %buildroot%_rpmlibdir/
mkdir -p %buildroot%_sysconfdir/alterator/backends
mkdir -p %buildroot%_datadir/dbus-1/interfaces
mkdir -p %buildroot%_datadir/polkit-1/actions
mkdir -p %buildroot%_alterator_datadir/applications
mkdir -p %buildroot%_alterator_datadir/backends

install -v -p -m 755 -D %name.filetrigger %buildroot%_rpmlibdir/10%name.filetrigger
install -v -p -m 755 -D alterator-generate-legacy-backends %buildroot%_libexecdir/%name
install -v -p -m 644 -D org.altlinux.alterator.legacy.xml %buildroot%_datadir/dbus-1/interfaces
install -v -p -m 644 -D org.altlinux.alterator.legacy.policy %buildroot%_datadir/polkit-1/actions
install -v -p -m 755 -D alterator-application-legacy %buildroot%_libexecdir/alterator-application-legacy/alterator-application-legacy
install -v -p -m 755 -D %buildroot%_bindir/alterator-application-legacy_dialog %buildroot%_libexecdir/alterator-application-legacy
install -v -p -m 644 -D legacy_runner.application %buildroot%_alterator_datadir/applications
install -v -b -m 644 -D legacy_runner.backend %buildroot%_alterator_datadir/backends

%files
%dir %_libexecdir/%name
%dir %_sysconfdir/alterator/backends
%_rpmlibdir/*
%_libexecdir/%name/*

%files -n alterator-interface-legacy
%_datadir/polkit-1/actions/org.altlinux.alterator.legacy.policy
%_datadir/dbus-1/interfaces/org.altlinux.alterator.legacy.xml

%files -n alterator-application-legacy
%exclude %_bindir/*
%dir %_alterator_datadir/applications
%dir %_libexecdir/alterator-application-legacy
%_libexecdir/alterator-application-legacy/*
%_alterator_datadir/applications/*.application
%_alterator_datadir/backends/legacy_runner.backend

%post
%_libexecdir/%name/alterator-generate-legacy-backends

%postun
if [ $1 = 0 ]; then
    find %_sysconfdir/alterator/backends -name "autogenerated-legacy-*.backend" -type f -print0 | xargs -0 rm -f '{}' ||:
fi

%changelog
