%ifdef _priority_distbranch
%define altbranch %_priority_distbranch
%else
%define altbranch %(rpm --eval %%_priority_distbranch)
%endif
%if "%altbranch" == "p10"
error exit
%endif

%define rname desktop-wallpapers

Name: alt-desktop-wallpapers
Version: 11.0.2
Release: alt2
%K5init no_altplace

Group: Graphical desktop/Other
Summary: ALT Desktop Wallpapers
Url: http://www.basealt.ru
License: Proprietary

BuildArch: noarch

Source: %rname-%version.tar

BuildRequires(pre): rpm-build-kf5
BuildRequires: extra-cmake-modules
BuildRequires: gcc-c++ qt5-base-devel
BuildRequires: jq
BuildRequires: /usr/bin/convert

%description
%summary.

%prep
%setup -n %rname-%version

%build
%K5build

%install
%K5install

# generate previews
for d in %buildroot/%_datadir/wallpapers/* ; do
    [ -f ${d}/metadata.desktop ] || continue
    ! [ -f ${d}/contents/screenshot.png -o -f ${d}/contents/screenshot.jpg ] || continue
    BG=`find ${d}/contents/images/ -type f -name \*.png -o -type f -name \*.jpg | head -n 1`
    [ -n "$BG" ] || continue
    EXT=`echo "$BG" | sed  's|.*\.||'`
    convert $BG -resize 400x250 ${d}/contents/screenshot.${EXT}
done

# install GNOME wallpapers
PREFIX=%buildroot
WALLDIR=%buildroot/%_datadir/wallpapers
GNOME_BG_PROP_DIR=%buildroot/%_datadir/gnome-background-properties
mkdir -p "$GNOME_BG_PROP_DIR"
# This script generates GNOME XML wallpaper configuration files using metadata extracted from metadata.json.
pushd $WALLDIR 1>/dev/null
ls -1d * | \
while read W_NAME; do
    F_PATH=`find $W_NAME/contents/images -type f | head -n 1`
    [ -n "$F_PATH" ] || continue
    F_PATH=`realpath $F_PATH`
    METADATA_FILE="${WALLDIR}/${W_NAME}/metadata.json"
    ID=$(jq -r '.KPlugin.Id' $METADATA_FILE)
    RF_PATH="%_datadir${F_PATH#*%_datadir}"
    cat <<EOF > "${GNOME_BG_PROP_DIR}/${W_NAME}.xml"
<?xml version="1.0"?>
<!DOCTYPE wallpapers SYSTEM "gnome-wp-list.dtd">
<wallpapers>
  <wallpaper deleted="false">
    <name>${ID}</name>
    <filename>${RF_PATH}</filename>
    <options>zoom</options>
    <shade_type>solid</shade_type>
    <pcolor>#ffffff</pcolor>
    <scolor>#000000</scolor>
  </wallpaper>
</wallpapers>
EOF
done
popd 1>/dev/null

%files
#%doc COPYING*
%_datadir/wallpapers/*
%_datadir/gnome-background-properties/*

%changelog
