%define _unpackaged_files_terminate_build 1

Name: alt-components
Version: 0.6.3
Release: alt1

Summary: Alterator application for managing system components
License: GPLv2+
Group: System/Configuration/Other
URL: https://altlinux.space/alterator/alt-components

Source: %name-%version.tar

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: cmake-modules
BuildRequires: gcc-c++
BuildRequires: qt6-base-common
BuildRequires: qt6-base-devel
BuildRequires: qt6-declarative-devel
BuildRequires: qt6-tools-devel
BuildRequires: boost-devel-headers
BuildRequires: libqbase-devel >= 0.1.0-alt3
BuildRequires: libtomlplusplus-devel
BuildRequires: nlohmann-json-devel
BuildRequires: libexpected-devel
BuildRequires: alterator-entry >= 0.3.1

Requires: alterator-backend-packages >= 0.2.9-alt1
Requires: alterator-backend-component >= 0.3.0-alt1
Requires: alterator-backend-systeminfo
Requires: libqbase
Requires: alt-components-base >= 0.7.12-alt1

Provides: alterator-application-components = %version-%release
Obsoletes: alterator-application-components < 0.4.0

%description
Alterator application for managing system components.

%prep
%setup

%build
%cmake
%cmake_build

%install
%cmakeinstall_std

%check
find ./alterator/*.{object,application,backend} -type f -exec alterator-entry validate {} \+

%files
%_datadir/alterator/applications/*.application
%_datadir/alterator/backends/*.backend
%_datadir/alterator/objects/*.object
%_datadir/polkit-1/actions/*.policy
%_datadir/dbus-1/interfaces/*.xml
%_bindir/alt-components
%_desktopdir/*.desktop

%changelog
