%global import_path github.com/grafana/alloy

# golang does not work well with lto
%global optflags_lto %nil
%ifarch loongarch64
# avoid "relocation R_LARCH_B26 overflow" error in cgo-compiled object files
%add_optflags -mcmodel=medium
%endif


Name:    alloy
Version: 1.10.2
Release: alt2

Summary: OpenTelemetry Collector distribution with programmable pipelines
License: Apache-2.0
Group:   Monitoring
Url:     https://grafana.com/oss/alloy
Vcs:     https://github.com/grafana/alloy

Packager: Maria Alexeeva <alxvmr@altlinux.org>

Source: %name-%version.tar
# Dependency source code archive (vendor dependencies)
# Generated by the <go mod vendor> command.
# The <-mod> flag for <go build> is included in %golang_build
Source1: vendor.tar
# Archive with generated web assets. Requires relatively recent yarn and nodejs.
# The generation is done with the commands:
# internal/web/ui
# go generate -tags builtinassets
#
# You need to do the same thing when updating the package!
Source2: assets.tar

ExcludeArch: %ix86 armh

BuildRequires(pre): rpm-build-golang
BuildRequires: golang
BuildRequires: libsystemd-devel
BuildRequires: libzstd-devel
BuildRequires: /proc

%description
Grafana Alloy is Grafana Labs' distribution of the OpenTelemetry
Collector. It is an OTLP-compatible collector with built-in
Prometheus optimizations that also supports signals across metrics,
logs, traces, and profiles.

%prep
%setup
tar -xf %SOURCE1
tar -xf %SOURCE2 -C internal/web/ui

%build
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"
export TAGS="netgo builtinassets promtail_journal_enabled external_libzstd"
export CGO_CFLAGS="%optflags"
export CGO_CXXFLAGS="%optflags"
export CGO_LDFLAGS="%optflags"

%golang_prepare

cd .build/src/%import_path
%golang_build .

%install
export BUILDDIR="$PWD/.build"
export IGNORE_SOURCES=1

%golang_install
# Hack to avoid rpm-build bug when generating debuginfo files.
# Bug link: https://bugzilla.altlinux.org/51874
# Generated sources contain square brackets, which are incorrectly handled by rpm-build.
# As a consequence, debuginfo files are not created.
strip -s %buildroot/%_bindir/*

# Setup directories
install -dm770 %buildroot%_sharedstatedir/%name
install -dm770 %buildroot%_sharedstatedir/%name/data
install -Dm644 packaging/rpm/%name.service %buildroot%_unitdir/%name.service
install -Dm644 packaging/environment-file %buildroot%_sysconfdir/sysconfig/%name
install -Dm644 packaging/config.%name %buildroot%_sysconfdir/%name/config.%name

%pre
groupadd -r -f %name 2>/dev/null ||:
useradd -r -g %name -c 'alloy user' \
    -s /sbin/nologin -M -d %_sharedstatedir/%name %name 2>/dev/null ||:
%post
%post_service %name
%preun
%preun_service %name

%files
%doc *.md
%_bindir/*
%config(noreplace) %_sysconfdir/sysconfig/%name
%config(noreplace) %_sysconfdir/%name/config.%name
%_unitdir/%name.service
%dir %attr(0770, %name, %name) %_sharedstatedir/%name
%dir %attr(0770, %name, %name) %_sharedstatedir/%name/data

%changelog
