%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,rpath=normal

%add_optflags %optflags_shared 

Name: aeskulap
Version: 0.2.2
Release: alt9.git8787e95
Summary: Medical image viewer for DICOM images
License: GPL/LGPL
Group: Graphics

Url: http://aeskulap.nongnu.org
# Git https://github.com/jenslody/aeskulap
Source: %name-%version.tar

Requires: dcmtk, GConf
BuildPreReq: gcc-c++, zlib-devel, libpng-devel, libtiff-devel
BuildPreReq: libxml2-devel, libssl-devel
BuildPreReq: libgtkmm2-devel, libglademm-devel
BuildPreReq: perl-XML-Parser, gettext, intltool
BuildPreReq: libdcmtk-devel
BuildRequires: desktop-file-utils GConf

%description
Aeskulap is a medical image viewer. It is able to load a series of special
images stored in the DICOM format for review. It is able to query and fetch
DICOM images from archive nodes (also called PACS) over the network. The
goal of this project is to create a full open source replacement for
commercially available DICOM viewers. It is based on gtkmm, glademm, and
gconfmm and designed to run under Linux. Ports of these packages are
available for different platforms. It should be quite easy to port It to
any platform were these packages are available.

%prep
%setup

%build
%add_optflags -D_FILE_OFFSET_BITS=64

%autoreconf
%configure \
	--with-gsettings \
	--disable-schemas-install \
	--disable-static \
	%nil

%install
%makeinstall_std
%find_lang %name
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Application \
	--add-category=MedicalSoftware \
	--add-category=Viewer \
	%buildroot%_desktopdir/aeskulap.desktop

%files -f %name.lang
%_bindir/aeskulap
%_datadir/aeskulap/*
%_datadir/applications/aeskulap.desktop
%_datadir/glib-2.0/schemas/org.gnu.aeskulap.gschema.xml
%_datadir/appdata/*
%_libdir/aeskulap/*
%_iconsdir/*/*/*
%doc ABOUT-NLS AUTHORS ChangeLog COPYING COPYING.LIB NEWS README

%changelog
