%define		_name	amule
%define		_rc	rc8
Name:		aMule
Version:	2.3.3
Release:	alt6

Summary:	aMule - eMule client.
License:	GPL-2.0-or-later
Group: 		Networking/File transfer

Url:		http://www.amule.org
Packager:	Ilya Mashkin <oddity@altlinux.ru>

Source:		%_name-%version.tar.gz

Conflicts:	xmule

Patch: amule-2.3.3-upstream-allow-autoconf_2.70.patch
# https://sources.debian.org/data/main/a/amule/1%3A2.3.3-3/debian/patches/wx3.2.patch
Patch1: debian-wx3.2.patch

# Automatically added by buildreq on Mon Jun 16 2008
BuildRequires: flex gcc gcc-c++ imake libpng-devel libreadline-devel libwxGTK3.2-devel xorg-cf-files
BuildRequires: libcryptopp-devel >= 6
BuildRequires: libupnp-devel binutils-devel libcurl-devel libtool bison libexpat-devel

#BuildRequires: rpm-build-compat >= 0.95

%description
The "all-platform eMule", it is a eMule-like client for ed2k network,
supporting Linux, *BSD platforms, Solaris, *MacOSX and *Win32 (*soon).
It was forked from xMule project back in September 2003 (not related
to it anymore, except little bits of old code), to drive it to a brand
new direction and quality. Uses wxWidgets (formerly known as wxWindows)
for multiplatform support.

%prep
%setup -q -n %_name-%version
%autopatch -p1

%__subst "s,aMuleConv(wxT(\"iso8859-1\")),aMuleConv(wxLocale::GetSystemEncodingName())," src/utils/aLinkCreator/src/alcc.h
%__subst "s,aMuleConv(wxT(\"iso8859-1\")),aMuleConv(wxLocale::GetSystemEncodingName())," src/utils/aLinkCreator/src/ed2khash.cpp
%__subst "s,#include <wx/strconv\.h>,#include <wx/strconv\.h>\n#include <wx/intl\.h>," src/utils/aLinkCreator/src/alcc.h
%__subst "s,#include <wx/strconv\.h>,#include <wx/strconv\.h>\n#include <wx/intl\.h>," src/utils/aLinkCreator/src/ed2khash.cpp

%build
export CXXFLAGS="%{optflags} -std=c++14"

./autogen.sh

%configure 	--enable-amulecmd \
		--enable-amulecmdgui \
		--enable-optimize \
		--disable-gsocket \
		--enable-alcc \
		--enable-alc \
		--enable-amule-daemon \
		--enable-webserver \
		--enable-webservergui \
		--enable-amule-gui \
		--disable-debug \
		--with-wx-config=%_bindir/wx-config
%make_build

%install
%make DESTDIR=%buildroot install

%find_lang --with-man %_name


%files -f %_name.lang
%doc %_defaultdocdir/amule/*
%_bindir/*
#%_menudir/*
%_datadir/applications/*
%_datadir/pixmaps/*
%_datadir/man/*/man1/*
%dir %_datadir/%_name
%_datadir/%_name/*
%doc %_man1dir/*
%dir %_docdir/amule

%changelog
