# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%global with_check 1

%add_python3_compile_include %_libexecdir/uranium

Name:    Uranium
Version: 5.4.0
Release: alt4

Summary:  A Python framework for building Desktop applications.
License: LGPL-3.0
Group:   Development/Python3
URL:     https://github.com/Ultimaker/Uranium

BuildRequires(pre): rpm-macros-python3 rpm-macros-cmake
BuildRequires: rpm-build-python3
BuildRequires: python3-devel cmake
BuildRequires:  %_bindir/doxygen
BuildRequires:  %_bindir/msgmerge

# Tests
%if 0%{?with_check}
BuildRequires:  python3-module-Arcus
BuildRequires:  python3-module-numpy
BuildRequires:  python3-module-numpy-testing
BuildRequires:  python3-module-scipy
BuildRequires:  python3-module-PyQt6
BuildRequires:  python3-module-pytest
BuildRequires:  python3-module-pip
BuildRequires:  python3-module-shapely
BuildRequires:  python3-module-twisted-web
BuildRequires:  python3-modules-sqlite3
BuildRequires:  python3-module-pyclipper
%endif

BuildArch: noarch

# Source-url: https://github.com/Ultimaker/%name/archive/refs/tags/%version.tar.gz
Source: %name-%version.tar

# Cmake bits taken from 4.13.1, before upstream went nuts with conan
Source2: mod_bundled_packages_json.py
Source3: UraniumPluginInstall.cmake
Source4: UraniumTests.cmake
Source5: UraniumTranslationTools.cmake
Source6: CMakeLists.txt
Source7: CPackConfig.cmake
Source8: Doxyfile

Patch: Uranium-4.7.1-set-default-languages.patch

# from Fedora
Patch2: Uranium-5.3.0-qt-try-ints-then-bytes-for-gl-mask-functions.patch
# Fix asserts for called once in Python 3.12
# https://github.com/Ultimaker/Uranium/pull/885.patch#/Uranium-5.3.0-python3.12.patch
Patch3: Uranium-5.3.0-python3.12.patch
# https://github.com/Ultimaker/Uranium/commit/e86d717035af317dab5d62851181873ec3c38ebe.patch
Patch4: upstream-Replace-deprecated-imp.patch

%description
%summary

%package doc
Summary: Documentation for %name package
Group: Documentation

%description doc
Documentation for Uranium, a Python framework for building 3D printing
related applications.

%prep
%setup
mkdir cmake
cp -a %SOURCE2 %SOURCE3 %SOURCE4 %SOURCE5 cmake/
rm CMakeLists.txt
cp -a %SOURCE6 %SOURCE7 %SOURCE8 .
 
# fix compile-shaders
sed -i 's|qsb |qsb-qt6 |g' scripts/compile-shaders

%autopatch -p1

%build
# there is no arch specific content, so we set LIB_SUFFIX to nothing
# see https://github.com/Ultimaker/Uranium/commit/862a246bdfd7e25541b04a35406957612c6f4bb7
%cmake -DLIB_SUFFIX:STR=
%cmake_build
%cmake_build -- doc

%install
%cmake_install
mv %buildroot/%_datadir/cmake* %buildroot/%_datadir/cmake

# Sanitize the location of locale files
pushd %buildroot%_datadir
mv uranium/resources/i18n locale
ln -s ../../locale uranium/resources/i18n
rm locale/uranium.pot
rm locale/*/uranium.po
popd

%find_lang uranium

%check
%if 0%{?with_check}
pip3 freeze
# skipping failing tests, see:
# * https://github.com/Ultimaker/Uranium/issues/594
# * https://github.com/Ultimaker/Uranium/issues/603
python3 -m pytest -v -k "not (TestSettingFunction and test_init_bad) \
	and not TestHttpRequestManager and not test_isValid \
	and not test_properties and not test_triggerAction \
	and not test_triggerActionWithData and not test_activeToolPanel"
%endif

%files -f uranium.lang
%doc LICENSE README.md
%python3_sitelibdir/*
%_libexecdir/uranium
%_datadir/uranium
%_datadir/cmake/Modules/*

%files doc
%doc html LICENSE

%changelog
