Name: SDL_mixer
Version: 1.2.12.0.173.ed76
Release: alt1
Summary: Simple DirectMedia Layer - mixer
Group: System/Libraries
License: LGPL-2.0+
Url: https://github.com/libsdl-org/SDL_mixer
Vcs: git://github.com/libsdl-org/SDL_mixer.git
# https://github.com/libsdl-org/SDL_mixer/tree/SDL-1.2

Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: %name-%version.tar
Patch: %name-1.2.11-alt5.patch

BuildRequires: gcc-c++ libSDL-devel libvorbis-devel libflac-devel libmikmod-devel
BuildRequires: libmad-devel
BuildRequires: libmpg123-devel libfluidsynth-devel

%description
SDL_mixer is a sample multi-channel audio mixer library.  It supports
any number of simultaneously playing channels of 16 bit stereo audio,
plus a single channel of music, mixed by the popular MikMod MOD,
Timidity MIDI, FLAC, Ogg Vorbis, and SMPEG MP3 libraries.

%package -n lib%name
Summary: Main library for %name
Group: System/Libraries
Requires: timidity-instruments
Provides: %name = %version-%release

%description -n lib%name
This package contains the library needed to run programs dynamically
linked with %name.

%package -n lib%name-devel
Summary: Header files for developing programs that will use %name
Group: Development/C
Requires: lib%name = %version-%release
Provides: %name-devel = %version-%release

%description -n lib%name-devel
This package contains the headers that programmers will need to develop
applications which will use %name.

%package utils
Summary: %name utilities for playing various types of sound files.
Group: System/Libraries
Requires: lib%name = %version-%release

%description utils
This package contains the %name console utilities for playing various
types of sound files using %name.

%prep
%setup
%patch -p1

cat acinclude/* > aclocal.m4

%build
autoconf
%configure \
	--enable-music-mp3-mad-gpl \
	--disable-music-mp3-shared \
	--disable-music-ogg-shared \
	--disable-music-flac-shared \
	--disable-music-mod-shared \
	--disable-static
# get rid of RPATH
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build

%install
%makeinstall_std

%files utils
%_bindir/playmus
%_bindir/playwave

%files -n lib%name
%doc CHANGES README
%_libdir/lib*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/SDL
%_pkgconfigdir/*.pc

%changelog
