Name: SDL_image
Version: 1.2.12.0.95.7adb
Release: alt1

Summary: Image loading library for SDL
Group: System/Libraries
License: Zlib
Url: https://github.com/libsdl-org/SDL_image
Vcs: git://github.com/libsdl-org/SDL_image.git
# https://github.com/libsdl-org/SDL_image/tree/SDL-1.2
# https://www.libsdl.org/projects/%name/release/%name-%version.tar.gz
Source: %name-%version.tar
Patch: SDL_image-1.2.12-fedora-interlaced-png-warning-fix.patch

%def_disable static
%define libname lib%name
# must match SDL_VERSION= in configure.ac
%define SDL_ver 1.2.10

BuildRequires: libSDL-devel >= %SDL_ver
BuildRequires: libjpeg-devel libpng-devel libtiff-devel zlib-devel libwebp-devel

%description
Simple DirectMedia Layer (SDL) is a cross-platform multimedia library
designed to provide fast access to the graphics frame buffer and audio
device.

%package -n %libname
Summary: %name runtime library
Group: System/Libraries

%description -n %libname
Simple DirectMedia Layer (SDL) is a cross-platform multimedia library
designed to provide fast access to the graphics frame buffer and audio
device.  This package contains a simple library for loading images of
various formats (BMP, PPM, PCX, GIF, JPEG, PNG) as SDL surfaces.

%package -n %libname-devel
Summary: %name development files
Group: Development/C
Requires: %libname = %version-%release

%description -n %libname-devel
This package contains %name development library and header files
required to build %name-based software.

%package -n %libname-devel-static
Summary: Static libraries for developing programs that will use %name
Group: Development/C
Requires: %libname-devel = %version-%release

%description -n %libname-devel-static
This package contains %name static library required to build
statically-linked %name-based software.

%prep
%setup
# %%patch -p2
# fgrep and egrep are obsolescent
sed -i 's|fgrep|grep -F|g' \
  $(find ./ -name 'configure*')
sed -i 's|egrep|grep -E|g' \
  $(find ./ -name 'configure*') \
  external/libwebp-1.0.3/gradlew
# required for autoreconf
mv acinclude m4
rm m4/l*.m4
touch NEWS AUTHORS ChangeLog

%build
# required for properly linked showimage
%autoreconf
%configure \
	--enable-jpg \
	--enable-png \
	--enable-tif \
	--disable-jpg-shared \
	--disable-png-shared \
	--disable-tif-shared \
	%{subst_enable static}
%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_bindir
install -pm755 .libs/showimage %buildroot%_bindir/

%files -n %libname
%_bindir/showimage
%_libdir/*.so.*

%files -n %libname-devel
%_libdir/*.so
%_includedir/SDL/*
%_pkgconfigdir/*
%doc README CHANGES

%if_enabled static
%files -n %libname-devel-static
%_libdir/*.a
%endif

%changelog
