%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

%def_with fcitx
%def_with ibus
%def_with nas
%def_with pulse

Name: SDL2
Version: 2.32.10
Release: alt1

Summary: Simple DirectMedia Layer
License: Zlib and MIT
Group: System/Libraries

Url: https://www.libsdl.org/
Vcs: https://github.com/libsdl-org/SDL
Packager: Nazarov Denis <nenderus@altlinux.org>

# https://www.libsdl.org/release/%name-%version.tar.gz
Source: %name-%version.tar

BuildRequires: libXext-devel
BuildRequires: libdbus-devel

%{?_with_fcitx:BuildRequires: fcitx5-devel}
BuildRequires: gcc-c++
BuildRequires: libGLES-devel
BuildRequires: libXScrnSaver-devel
BuildRequires: libXxf86vm-devel
BuildRequires: libalsa-devel
%{?_with_nas:BuildRequires: libaudio-devel}
BuildRequires: libdrm-devel
BuildRequires: libesd-devel
BuildRequires: libgbm-devel
%{?_with_ibus:BuildRequires: libibus-devel}
BuildRequires: libjack-devel
%{?_with_pulse:BuildRequires: libpulseaudio-devel}
BuildRequires: libsamplerate-devel
BuildRequires: libudev-devel
# Wayland support
BuildRequires: libxkbcommon-devel
BuildRequires: libwayland-client-devel
BuildRequires: libwayland-cursor-devel
BuildRequires: libwayland-egl-devel
BuildRequires: libwayland-server-devel
BuildRequires: wayland-devel
BuildRequires: wayland-protocols

%description
This is the Simple DirectMedia Layer, a generic API that provides low
level access to audio, keyboard, mouse, and display framebuffer across
multiple platforms.

%package -n lib%name
Summary: Simple DirectMedia Layer
Group: System/Libraries

%description -n lib%name
This is the Simple DirectMedia Layer, a generic API that provides low
level access to audio, keyboard, mouse, and display framebuffer across
multiple platforms.

%package -n lib%name-devel
Summary: Libraries, includes and more to develop SDL applications.
Group: Development/C
Conflicts: rpm-build < 4.0.4-alt100.96

%description -n lib%name-devel
This is the Simple DirectMedia Layer, a generic API that provides low
level access to audio, keyboard, mouse, and display framebuffer across
multiple platforms.

This is the libraries, include files and other resources you can use
to develop SDL applications.

%package -n lib%name-devel-static
Summary: Static libraries to develop SDL applications.
Group: Development/C
Requires: lib%name-devel = %EVR

%description -n lib%name-devel-static
This is the Simple DirectMedia Layer, a generic API that provides low
level access to audio, keyboard, mouse, and display framebuffer across
multiple platforms.

This is the static libraries you can use to develop SDL applications.

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS)
%add_optflags -Wno-incompatible-pointer-types
%ifarch loongarch64
export LDFLAGS='-mlsx -mlasx'
%endif
%configure \
    --enable-video-vulkan \
    --enable-video-wayland \
    --disable-rpath
    
%make_build

%install
%makeinstall_std
%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1

%files -n lib%name
%doc BUGS.txt CREDITS.txt README*.txt WhatsNew.txt
%_libdir/lib%name-2.0.so.*

%files -n lib%name-devel
%_bindir/sdl2-config
%_includedir/%name/
%_libdir/lib%name.so
%_libdir/cmake/%name/
%_pkgconfigdir/sdl2.pc
%_aclocaldir/sdl2.m4

%files -n lib%name-devel-static
%_libdir/lib%{name}*.a

%changelog
