%define _unpackaged_files_terminate_build 1

Name: R-base
Version: 4.5.0
Release: alt1

Summary: A language for data analysis and graphics
License: GPLv2
Group: Sciences/Mathematics

Url: https://www.r-project.org
Source: R-%version.tar
ExcludeArch: i586

BuildRequires: bzlib-devel
BuildRequires: gcc-c++
BuildRequires: gcc-fortran
BuildRequires: ghostscript-common
BuildRequires: java-headless
BuildRequires: libXmu-devel
BuildRequires: libcurl-devel
BuildRequires: libgomp-devel
BuildRequires: libgomp-devel
BuildRequires: libicu-devel
BuildRequires: libjpeg-devel
BuildRequires: liblapack-devel
BuildRequires: liblapack-devel
BuildRequires: liblzma-devel
BuildRequires: libopenblas-devel
BuildRequires: libpango-devel
BuildRequires: libpcre2-devel
BuildRequires: libreadline-devel
BuildRequires: libtiff-devel
BuildRequires: libtre-devel
BuildRequires: makeinfo
BuildRequires: tex-common
BuildRequires: texi2dvi
BuildRequires: texlive
BuildRequires: texlive-collection-basic
BuildRequires: texlive-dist
BuildRequires: tk-devel

%description
R is 'GNU S' - A language and environment for statistical computing
and graphics. R is similar to the award-winning S system, which was
developed at Bell Laboratories by John Chambers et al. It provides a
wide variety of statistical and graphical techniques (linear and
nonlinear modelling, statistical tests, time series analysis,
classification, clustering, ...).

R is designed as a true computer language with control-flow
constructions for iteration and alternation, and it allows users to
add additional functionality by defining new functions. For
computationally intensive tasks, C, C++ and Fortran code can be
linked and called at run time.

S is the statistician's Matlab and R is to S what Octave is to Matlab.

%prep
%setup -n R-%version
rm src/extra/blas/*.f src/modules/lapack/*.f
%ifarch %e2k
tar -xzf src/library/Recommended/mgcv.tgz
sed -i -E "/#pragma omp .*num_threads\(\*/{s/.*num_threads\((\*[^(]*)\).*/int nthr_fix=\\1;\n&/;s/num_threads\((\*[^(]*)\).*/num_threads(nthr_fix)/}" mgcv/src/{discrete,gdi}.c
sed -i -E "s/num_threads\((\*[^(]*)\).*/num_threads(nthr_fix)/;s/int \*nt.*\) \{/&int nthr_fix=*nt;/" mgcv/src/mat.c
tar -czf src/library/Recommended/mgcv.tgz mgcv ; rm -rf mgcv
%endif

%build
%define verid %(v=%version; IFS=.; set $v; echo "$1.$2")
%define Rhome %_libdir/R
%define Rbindir %Rhome/bin
%define Rdocdir %_docdir/R-%verid
export	lt_cv_prog_cc_static_works=no \
	ac_cv_path_R_ZIPCMD=zip ac_cv_path_R_UNZIPCMD=unzip \
	ac_cv_path_R_BROWSER=xdg-open ac_cv_path_R_PDFVIEWER=xdg-open \
	ac_cv_path_PAGER='less -isR' ac_cv_prog_R_PRINTCMD=lpr
%add_optflags -fno-strict-aliasing

%configure \
	--enable-prebuilt-html \
	--enable-R-shlib --with-x \
    --disable-rpath \
	--with-system-tre \
    --with-gnu-ld \
    %longdouble \
	--with-blas=openblas --with-lapack=lapack \
	--with-tcl-config=%_libdir/tclConfig.sh --with-tk-config=%_libdir/tkConfig.sh \
	--libdir='${prefix}/%_lib' rincludedir='${prefix}/include/R' \
	rdocdir='${prefix}/share/doc/R-%verid'

%make_build
%make_build pdf info

%install
%makeinstall_std install-pdf install-info

mv %buildroot{%Rhome/lib,%_libdir}/libR.so

# this symlink is needed for R-studio
ln -s $(relative %_libdir/libR.so %Rhome/lib/libR.so) %buildroot%Rhome/lib/libR.so

ln -s `relative %Rdocdir %Rhome/doc` %buildroot%Rhome/doc
ln -s `relative %_includedir/R %Rhome/include` %buildroot%Rhome/include

cmp %buildroot%_bindir/R %buildroot%Rhome/bin/R
ln -snfv `relative %Rhome/bin/R %_bindir/R` %buildroot%_bindir/R
cmp %buildroot%_bindir/Rscript %buildroot%Rhome/bin/Rscript
ln -snfv `relative %Rhome/bin/Rscript %_bindir/Rscript` %buildroot%_bindir/Rscript

fgrep -r %buildroot %buildroot && exit 1

mkdir -p %buildroot/etc/R
mv %buildroot%Rhome/etc/* %buildroot/etc/R/
rmdir %buildroot%Rhome/etc
ln -s `relative /etc/R %Rhome/etc` %buildroot%Rhome/etc

mkdir -p %buildroot%_desktopdir
cat > %buildroot%_desktopdir/%name.desktop <<EOF
[Desktop Entry]
Version=1.0
Type=Application
Name=R
Comment=R - a language for statistical computing
Icon=R
Exec=R
Terminal=true
Categories=Science;Math;
EOF

# use system libtool
[ -f %buildroot%Rhome/bin/libtool ]
ln -snfv `relative %_bindir/libtool %Rhome/bin/libtool` %buildroot%Rhome/bin/libtool

%define _perl_lib_path %Rhome/share/perl
%add_findprov_skiplist %Rhome/share/perl/*.pl

rm -fv \
  %buildroot%_infodir/dir* \
  %buildroot%Rhome/COPYING \
  %buildroot%Rhome/SVN-REVISION \
  #

%check
export TZ="UTC"
make \
  check \
%ifnarch aarch64
  check-recommended \
# FIXME: [aarch64] 'tests/anova.gls.R' failed.
%endif
  #

%files
	%doc doc/NEWS README
	%_bindir/R
	%_bindir/Rscript
	%_man1dir/R.*
	%_man1dir/Rscript.*
	%_libdir/libR.so
	%_desktopdir/%name.desktop

%dir	%Rhome
%dir	%Rhome/lib
	%Rhome/lib/*

%dir	%Rbindir
	%Rbindir/R
	%Rbindir/Rscript

	%Rbindir/BATCH
	%Rbindir/Rcmd
	%Rbindir/Rd2pdf
	%Rbindir/Rdconv
	%Rbindir/Rprof
	%Rbindir/pager
	%Rbindir/Stangle
	%Rbindir/Sweave
	%Rbindir/javareconf
	%Rbindir/rtags

%dir	%Rbindir/exec
	%Rbindir/exec/R

%dir	/etc/R
%config(noreplace) /etc/R/*
	%Rhome/etc

%define R_library_path %Rhome/library
%dir	%R_library_path

%define R_library() \
%dir	%R_library_path/%1 \
	%R_library_path/%1/* \
%exclude %R_library_path/%1/html \
%doc	%R_library_path/%1/html

# avoid dependency on R-devel
%add_findreq_skiplist %R_library_path/*/include/*.h

# Priority: base
	%R_library base
	%R_library datasets
	%R_library grDevices
	%R_library graphics
	%R_library grid
	%R_library methods
	%R_library splines
	%R_library stats
	%R_library stats4
	%R_library tools
	%R_library utils
	%R_library compiler
# Priority: recommended
	%R_library KernSmooth
	%R_library MASS
	%R_library Matrix
	%R_library boot
	%R_library class
	%R_library cluster
	%R_library codetools
	%R_library foreign
	%R_library lattice
	%R_library mgcv
	%R_library nlme
	%R_library nnet
	%R_library rpart
	%R_library spatial
	%R_library survival
	%R_library parallel

	%R_library_path/translations

%dir	%Rhome/modules
	%Rhome/modules/*.so*
%dir	%Rhome/share
	%Rhome/share/*

%dir	%Rdocdir
%doc	%Rdocdir/[A-Z]*
%exclude %Rdocdir/COPYING*
	%Rhome/doc

%package -n R-full
Summary: Meta-package that installs all components of R Statitical Environment
Group: Development/Other
Requires: R-devel = %version-%release R-tcltk = %version-%release R-doc-html = %version-%release gcc-c++ gcc-fortran liblapack-devel make

%description -n R-full
Meta-package that installs all components of R Statitical Environment

%package -n R-devel
Summary: Development files for the R Statistical Environment
Group: Development/Other
Requires(pre,postun): R-base = %version-%release

%description -n R-devel
R is 'GNU S' - A language and environment for statistical computing
and graphics. R is similar to the award-winning S system, which was
developed at Bell Laboratories by John Chambers et al. It provides a
wide variety of statistical and graphical techniques (linear and
nonlinear modelling, statistical tests, time series analysis,
classification, clustering, ...).

%files -n R-full
%nil

%files -n R-devel
%dir	%Rbindir
	%Rbindir/COMPILE
	%Rbindir/INSTALL
	%Rbindir/LINK
	%Rbindir/REMOVE
	%Rbindir/Rdiff
	%Rbindir/SHLIB
	%Rbindir/build
	%Rbindir/check
	%Rbindir/config
	%Rbindir/libtool
	%Rbindir/mkinstalldirs

%dir	%_includedir/R
	%_includedir/R/*.h
%dir	%_includedir/R/R_ext
	%_includedir/R/R_ext/*.h
	%Rhome/include

%dir	%Rhome

	%_pkgconfigdir/libR.pc

%package -n R-tcltk
Summary: Tcl/Tk Interface for the R Statistical Environment
Group: Sciences/Mathematics
Requires: R-base = %version-%release

%description -n R-tcltk
R is 'GNU S' - A language and environment for statistical computing
and graphics. R is similar to the award-winning S system, which was
developed at Bell Laboratories by John Chambers et al. It provides a
wide variety of statistical and graphical techniques (linear and
nonlinear modelling, statistical tests, time series analysis,
classification, clustering, ...).

This package provides access to the platform-independent Tcl scripting
language and Tk GUI elements.

%files -n R-tcltk
%add_tcl_lib_path %R_library_path/tcltk
%dir	%R_library_path
	%R_library tcltk

%package -n R-doc-html
Summary: HTML manuals for the R Statistical Environment
Group: Sciences/Mathematics
Requires: R-base = %version-%release
Requires: xdg-utils

%description -n R-doc-html
R is 'GNU S' - A language and environment for statistical computing
and graphics. R is similar to the award-winning S system, which was
developed at Bell Laboratories by John Chambers et al. It provides a
wide variety of statistical and graphical techniques (linear and
nonlinear modelling, statistical tests, time series analysis,
classification, clustering, ...).

%files -n R-doc-html
%dir	%Rdocdir
%dir	%Rdocdir/html/
%doc	%Rdocdir/html/*
%dir	%Rdocdir/manual/
%doc	%Rdocdir/manual/*.html
%dir    %Rdocdir/manual/images/
%doc    %Rdocdir/manual/images/*.png

%package -n R-doc-pdf
Summary: PDF manuals for the R Statistical Environment
Group: Sciences/Mathematics
Conflicts: R-base > %version, R-base < %version
Requires: xdg-utils

%description -n R-doc-pdf
R is 'GNU S' - A language and environment for statistical computing
and graphics. R is similar to the award-winning S system, which was
developed at Bell Laboratories by John Chambers et al. It provides a
wide variety of statistical and graphical techniques (linear and
nonlinear modelling, statistical tests, time series analysis,
classification, clustering, ...).

%files -n R-doc-pdf
%dir	%Rdocdir
%dir	%Rdocdir/manual/
%doc	%Rdocdir/manual/*.pdf

%package -n R-doc-info
Summary: Info manuals for the R Statistical Environment
Group: Sciences/Mathematics
Conflicts: R-base > %version, R-base < %version

%description -n R-doc-info
R is 'GNU S' - A language and environment for statistical computing
and graphics. R is similar to the award-winning S system, which was
developed at Bell Laboratories by John Chambers et al. It provides a
wide variety of statistical and graphical techniques (linear and
nonlinear modelling, statistical tests, time series analysis,
classification, clustering, ...).

%files -n R-doc-info
%_infodir/R-*.info*

%changelog
