Name: PySolFC
Version: 2.12.0
Release: alt3

Summary: A collection of solitare card games

License: GPL-2.0+
Group: Games/Cards
Url: http://pysolfc.sourceforge.net

Source0: http://downloads.sourceforge.net/pysolfc/%name-%version.tar.bz2
Source1: PySol.desktop
Source2: pysol-start-script

Patch2: 06d2fd5b90c29cbfe9b938676cc85c514cbbcca1.patch

Provides: pysol = 5.%version
Requires: PySolFC-Cardsets

BuildRequires(pre): rpm-build-python3

BuildArch: noarch

# we will use tk
%add_python3_req_skip gtk

# never use jnius
%add_python3_req_skip jnius_never_use

# python3-module-six have no requirements to support six.moves.tkinter (https://bugzilla.altlinux.org/40809)
Requires: python3-modules-tkinter

%description
%name is a collection of more than 1000 solitaire card games. It is a fork
of PySol solitare. Its features include modern look and feel (uses Tile widget
set), multiple cardsets and tableau backgrounds, sound, unlimited undo, player
statistics, a hint system, demo games, a solitaire wizard, support for user
written plug-ins, an integrated HTML help browser, and lots of documentation.

%package -n python3-module-PySolFC
Summary: Supplemental python module for %name solitaire game collection
Group: Games/Cards

%description -n python3-module-PySolFC
Supplemental python module for %name solitaire game collection

%prep
%setup
%patch2 -p1
# Set correct python2 executable in shebang
subst 's|#!.*python$|#!%__python3|' $(grep -Rl '#!.*python$' *)
# force skip jinus if it is installed
subst 's|jnius|jnius_never_use|' pysollib/init.py

%build
%python3_build

%install
%python3_install
#-O1
# install desktop file
rm %buildroot%_desktopdir/*.desktop
install -D %SOURCE1 %buildroot%_desktopdir/%name.desktop

# install the startup wrapper
mv %buildroot%_bindir/pysol.py %buildroot%_datadir/%name
install -m755 %SOURCE2 %buildroot/%_bindir/pysol

%find_lang pysol

# we will use tk
rm -rv %buildroot%python3_sitelibdir/pysollib/pysolgtk
rm -rv %buildroot%python3_sitelibdir/pysollib/kivy

# drop shell script with extra deps
rm -v %buildroot%_datadir/PySolFC/themes/clearlooks/convert_imgs.sh

%files -f pysol.lang
%doc AUTHORS.md README.md PKG-INFO
%dir %_datadir/%name
%_bindir/pysol
%_datadir/%name/*
#_datadir/pixmaps/*
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/pysol.png

%files -n python3-module-PySolFC
%python3_sitelibdir/pysollib/*
%python3_sitelibdir/*egg-info

%changelog
