%define nm_version 1.1.90

%define _unpackaged_files_terminate_build 1

%def_with gtk4

Name: NetworkManager-ssh
Version: 1.4.2
Release: alt1
License: GPLv2+
Group: System/Configuration/Networking
Summary: NetworkManager VPN plugin for SSH
Url: https://github.com/danfruehauf/NetworkManager-ssh
Vcs: https://github.com/danfruehauf/NetworkManager-ssh.git
Source0: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: intltool
BuildRequires: libnm-devel >= %nm_version
BuildRequires: libnma-devel
BuildRequires: libgtk+3-devel
BuildRequires: libsecret-devel
%{?_with_gtk4:BuildRequires: libgtk4-devel libnma-gtk4-devel}

Requires: NetworkManager-daemon   >= %nm_version
Requires: openssh-clients

%description
This package contains software for integrating VPN capabilities with
the OpenSSH server with NetworkManager.

%package gtk-common
Summary: Common part of %name GTK support
Group: Graphical desktop/GNOME
Requires: %name = %version-%release

%description gtk-common
This package contains common part for %name GTK support.

%package gtk3
Summary: Files for GTK3 applications to use %name
Group: Graphical desktop/GNOME
Requires: %name-gtk-common = %version-%release

Obsoletes: %name-gnome < 0.9.1-alt2
Provides: %name-gnome = %version-%release

Obsoletes: %name-gtk < 1.2.13-alt1
Provides: %name-gtk = %version-%release

%description gtk3
This package contains files for GTK3 applications to use %name.

%if_with gtk4
%package gtk4
Summary: Files for GTK4 applications to use %name
Group: Graphical desktop/GNOME
Requires: %name-gtk-common = %version-%release

Obsoletes: %name-gnome < 0.9.1-alt2
Provides: %name-gnome = %version-%release

%description gtk4
This package contains files for GTK4 applications to use %name.
%endif

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--disable-static \
	--libexecdir=%_libexecdir/NetworkManager \
	--localstatedir=%_var \
	--without-libnm-glib \
	%{subst_with gtk4} \
	--with-dist-version=%version-%release \
	--disable-silent-rules \
	--enable-more-warnings=error
%make_build

%install
%makeinstall_std
%find_lang %name

%check
make check

%files
%doc AUTHORS README README.md
%_libexecdir/NetworkManager/nm-ssh-service
%_libdir/NetworkManager/libnm-vpn-plugin-ssh.so
%config %_sysconfdir/dbus-1/system.d/nm-ssh-service.conf
%config %_libexecdir/NetworkManager/VPN/nm-ssh-service.name

%files gtk-common -f %name.lang
%_libexecdir/NetworkManager/nm-ssh-auth-dialog
%_datadir/metainfo/*.xml

%files gtk3
%_libdir/NetworkManager/libnm-gtk3-vpn-plugin-ssh-editor.so

%if_with gtk4
%files gtk4
%_libdir/NetworkManager/libnm-gtk4-vpn-plugin-ssh-editor.so
%endif

%exclude %_libdir/NetworkManager/*.la

%changelog
