%define dbus_version 1.2.12-alt2
%define libdbus_glib_version 0.76

%define ppp_version %(pkg-config --modversion pppd 2>/dev/null || (%{__awk} '/^#define VERSION/ { print $NF }' /usr/include/pppd/patchlevel.h 2>/dev/null||echo none)|/usr/bin/tr -d '"')
%define wpa_supplicant_version 0.7.3-alt3
%define dhcpcd_version 9.3.3
%define openresolv_version 3.5.4-alt3

%def_enable systemd
%def_enable introspection
%def_enable teamdctl
%def_enable nmtui
%def_enable bluez5dun
%def_enable vala
%def_enable nmcloudsetup
%def_enable ifcfg
%ifnarch %e2k %mips
%def_enable ovs
%else
%def_disable ovs
%endif
%def_disable iwd

%if %{expand:%%{!?_without_check:%%{!?_disable_check:1}}0}
%define tests yes
%else
%define tests no
%endif

%ifarch %e2k
%def_disable lto
%else
%def_enable lto
%endif

%define _name %name-daemon
%define nmlibdir %_prefix/lib/NetworkManager
%define dispatcherdir %nmlibdir/dispatcher.d
%define nmplugindir %_libdir/%name/%version-%release

%define _unpackaged_files_terminate_build 1

Name: NetworkManager
Version: 1.54.1
Release: alt1
License: GPLv2+ and LGPLv2.1+
Group: System/Configuration/Networking
Summary: Install NetworkManager daemon and plugins
Url: https://networkmanager.dev/
Vcs: https://gitlab.freedesktop.org/NetworkManager/NetworkManager.git
Source: %name-%version.tar
Source1: %name.conf
Source2: 50-ntp
Source5: 20-hostname
Source6: NetworkManager.sysconfig
Source7: 30-efw
Source8: 80-etcnet-iface-scripts
Source9: NetworkManager-prestart
Source10: nm-dispatcher-sh-functions
Source11: NetworkManager.init
Source12: ifcfg-rh-plugin.conf
Patch: %name-%version-%release.patch

BuildRequires(pre): meson rpm-macros-meson >= 1.3.1-alt1
BuildRequires(pre): rpm-macros-systemd >= 6

# For tests
%{?!_without_check:%{?!_disable_check:BuildPreReq: dbus dhcpcd dhcp-client}}
%{?!_without_check:%{?!_disable_check:BuildRequires: python3-module-dbus python3-module-pexpect}}
%{?!_without_check:%{?!_disable_check:BuildRequires: /dev/pts}}
# For /etc/machine-id
%{?!_without_check:%{?!_disable_check:BuildRequires: systemd}}

BuildRequires: intltool libgcrypt-devel libtool
BuildRequires: iproute2 ppp-devel
BuildRequires: libdbus-glib-devel >= %libdbus_glib_version
BuildRequires: libpolkit1-devel libnss-devel libgio-devel libuuid-devel gtk-doc
BuildRequires: libudev-devel
BuildRequires: libmm-glib-devel
BuildRequires: libndp-devel
BuildRequires: libreadline-devel
BuildRequires: libaudit-devel
BuildRequires: libcurl-devel libpsl-devel
BuildRequires: libjansson-devel
BuildRequires: python3-module-pygobject3
%{?_enable_teamdctl:BuildRequires: libteamdctl-devel}
%{?_enable_nmtui:BuildRequires: libnewt-devel}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgudev-gir-devel}
%{?_enable_systemd:BuildRequires: systemd-devel libsystemd-login-devel}
%{?_enable_bluez5dun:BuildRequires: libbluez-devel}
%{?_enable_vala:BuildRequires(pre): rpm-build-vala}
%{?_enable_vala:BuildRequires: vala-tools}
# For create-exports-NetworkManager.sh
BuildRequires: /proc

Requires: dnsmasq

Requires: %name-adsl = %version-%release
Requires: %name-bluetooth = %version-%release
%{?_enable_teamdctl:Requires: %name-team}
Requires: %name-wifi = %version-%release
Requires: %name-wwan = %version-%release
Requires: %name-ppp = %version-%release

# In 126 version /usr/libexec/polkit-1/polkit-agent-helper-1 -> /usr/lib/polkit-1/polkit-agent-helper-1
Conflicts: polkit < 126-alt1

# Drop busctl from Requires:
# it from NetworkManager.service and pulls systemd.
%filter_from_requires /^\/usr\/bin\/busctl/d

%description
NetworkManager is a system service that manages network interfaces and
connections based on user or automatic configuration. It supports
Ethernet, Bridge, Bond, VLAN, Team, InfiniBand, Wi-Fi, mobile broadband
(WWAN), PPPoE and other devices, and supports a variety of different VPN
services.

This is virtual package for install NetworkManager daemon
and all its plugins (excluding VPN plugins).

%package daemon
License: GPLv2+
Group: System/Configuration/Networking
Summary: Network Link Manager and User Applications
Requires: dbus >= %dbus_version
Requires: iproute2 openssl
Requires: nss >= 3.11.7
Requires: openresolv >= %openresolv_version
Requires: openresolv-dnsmasq >= %openresolv_version
Requires: libshell

Conflicts: NetworkManager-vpnc < 1.1.90
Conflicts: NetworkManager-openvpn < 1.1.90
Conflicts: NetworkManager-pptp < 1.1.90
Conflicts: NetworkManager-openconnect < 1.1.90
Conflicts: NetworkManager-l2tp < 1.1.0
Conflicts: NetworkManager-ssh < 1.1.0
Conflicts: NetworkManager-gnome < 1.1.90

Conflicts: dhcpcd < %dhcpcd_version

Obsoletes: nmcli

Provides: network-config-subsystem

%description daemon
NetworkManager is a system service that manages network interfaces and
connections based on user or automatic configuration. It supports
Ethernet, Bridge, Bond, VLAN, Team, InfiniBand, Wi-Fi, mobile broadband
(WWAN), PPPoE and other devices, and supports a variety of different VPN
services.

This package contents NetworkManager daemon itself and other
utilities.

%package config-server
Summary: NetworkManager config file for "server-like" defaults
Group: System/Configuration/Networking
BuildArch: noarch
Requires: %_name = %version-%release

%description config-server
This adds a NetworkManager configuration file for "server-like" defaults.
In particular, it stops NetworkManager from automatically running DHCP
on unconfigured ethernet devices, and allows connections with static IP
addresses to be brought up even on ethernet devices with no carrier.

This package is intended to be installed by default for server
deployments.

%package adsl
License: GPLv2+
Summary: ADSL device plugin for NetworkManager
Group: System/Configuration/Networking
Requires: ppp-pppoe
Requires: %_name = %version-%release
Requires: %name-ppp = %version-%release

%description adsl
This package contains NetworkManager support for ADSL devices.

%package bluetooth
License: GPLv2+
Summary: Bluetooth device plugin for NetworkManager
Group: System/Configuration/Networking
Requires: %_name = %version-%release
Requires: %name-wwan = %version-%release

%description bluetooth
This package contains NetworkManager support for Bluetooth devices.

%package ovs
License: GPLv2+
Summary: OpenVSwitch device plugin for NetworkManager
Group: System/Configuration/Networking
Requires: %_name = %version-%release
Requires: openvswitch

%description ovs
This package contains NetworkManager support for OpenVSwitch bridges.

%package team
License: GPLv2+
Summary: Team device plugin for NetworkManager
Group: System/Configuration/Networking
Requires: teamd
Requires: %_name = %version-%release

%description team
This package contains NetworkManager support for team devices.

%if_enabled nmcloudsetup
%package cloud-setup
License: LGPLv2.1+
Summary: Automatically configure NetworkManager in cloud
Group: System/Configuration/Networking
Requires: %_name = %version-%release

%description cloud-setup
Installs a nm-cloud-setup tool that can automatically configure
NetworkManager in cloud setups. Currently only EC2 is supported.
This tool is still experimental.
%endif

%if_enabled ifcfg
%package ifcfg-rh
License: GPLv2+
Summary: NetworkManager settings plugin for Red Hat ifcfg files
Group: System/Configuration/Networking
Requires: %_name = %version-%release

%description ifcfg-rh
This package contains NetworkManager settings plugin for integration with
standard Red Hat ifcfg files.
This package exists for configuring VMs only and shouldn't be installed in
the regular ALT systems.
%endif

%package wifi
License: GPLv2+
Summary: Wifi plugin for NetworkManager
Group: System/Configuration/Networking
Requires: wpa_supplicant >= %wpa_supplicant_version
Requires: %_name = %version-%release

%description wifi
This package contains NetworkManager support for Wifi and OLPC devices.

%package wwan
License: GPLv2+
Summary: Mobile broadband device plugin for NetworkManager
Group: System/Configuration/Networking
Requires: ModemManager >= 0.7
Requires: %_name = %version-%release
Requires: mobile-broadband-provider-info

%description wwan
This package contains NetworkManager support for mobile broadband (WWAN) devices.

%package ppp
License: GPLv2+
Summary: PPP plugin for NetworkManager
Group: System/Configuration/Networking
Requires: %_name = %version-%release
Requires: ppp = %ppp_version

%description ppp
This package contains NetworkManager support for PPP.

%package tui
License: GPLv2+
Summary: Curses-based Text User Interface for NetworkManager
Group: System/Configuration/Networking
Requires: %_name = %version-%release

%description tui
%summary

%package -n libnm
License: LGPLv2.1+
Summary: Library for adding NetworkManager support to applications
Group: System/Libraries

%description -n libnm
This package contains the libraries that make it easier to use some
NetworkManager functionality from applications.

%package -n libnm-devel
License: LGPLv2.1+
Summary: Header files for adding NetworkManager support to applications.
Group: Development/C
Requires: glib2-devel
Requires: pkgconfig
Requires: libdbus-glib-devel >= %libdbus_glib_version
Requires: libnm = %version-%release

%description -n libnm-devel
This package contains the header and pkg-config files for development
applications using NetworkManager functionality.

%package -n libnm-devel-doc
License: GFDL-1.1+
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch

%description -n libnm-devel-doc
This package contains development documentation for %name.

%package -n libnm-gir
License: LGPLv2.1+
Summary: GObject introspection data for the NetworkManager (libnm)
Group: System/Libraries
Requires: libnm = %version-%release

%description -n libnm-gir
GObject introspection data for the NetworkManager (libnm).

%package -n libnm-gir-devel
License: LGPLv2.1+
Summary: GObject introspection devel data for the NetworkManager (libnm)
Group: System/Libraries
BuildArch: noarch
Requires: libnm-gir = %version-%release

%description -n libnm-gir-devel
GObject introspection devel data for the NetworkManager (libnm).

%prep
%setup
%patch -p1

%build
%meson \
	--libexecdir=%_libexecdir/NetworkManager \
	--localstatedir=%_var \
	-Dcrypto=nss \
	-Ddhclient=/sbin/dhclient \
	-Ddhcpcd=true \
	-Dconfig_dhcp_default=internal \
	-Ddnsmasq=/usr/sbin/dnsmasq \
	-Ddocs=true \
	-Dconfig_dns_rc_manager_default=auto \
	-Dresolvconf=/sbin/resolvconf \
	-Dconcheck=true \
	-Dpppd_plugin_dir=%_libdir/pppd/%ppp_version \
	-Dppp=true \
	-Dsystem_ca_path=/etc/pki/tls/cert.pem \
	-Dtests=%tests \
%if_enabled systemd
	-Dsystemdsystemunitdir=%_unitdir \
	-Dsession_tracking=systemd \
	-Dsuspend_resume=systemd \
	-Dconfig_logging_backend_default=journal \
%else
	-Dsession_tracking=ck \
	-Dsuspend_resume=upower \
	-Dconfig_logging_backend_default=syslog \
%endif
	-Dudev_dir=%_udevdir \
	-Dpolkit=true \
	-Dpolkit_agent_helper_1=/usr/lib/polkit-1/polkit-agent-helper-1 \
	-Dmodify_system=false \
	-Detcnet_alt=true \
	%{subst_enable_meson_bool ifcfg ifcfg_rh} \
	-Dconfig_migrate_ifcfg_rh_default=false \
	-Difupdown=false \
	-Dconfig_plugins_default='etcnet-alt' \
	-Dmodem_manager=true \
	-Dmobile_broadband_provider_info_database=%_datadir/mobile-broadband-provider-info/serviceproviders.xml \
	%{subst_enable_meson_bool teamdctl teamdctl} \
	%{subst_enable_meson_bool ovs ovs} \
	%{subst_enable_meson_bool nmtui nmtui} \
	%{subst_enable_meson_bool bluez5dun bluez5_dun} \
	-Dintrospection=true \
	%{subst_enable_meson_bool lto b_lto} \
	%{subst_enable_meson_bool vala vapi} \
	%{subst_enable_meson_bool nmcloudsetup nm_cloud_setup} \
	-Dlibaudit=yes-disabled-by-default \
	-Dofono=false \
	-Dlibpsl=true \
	-Dfirewalld_zone=true \
	-Dnft=/usr/sbin/nft \
	-Diptables=/sbin/iptables \
	-Dip6tables=/sbin/ip6tables \
	%{subst_enable_meson_bool iwd iwd} \
	-Dconfig_wifi_backend_default=wpa_supplicant \
	-Dselinux=false \
	-Dnbft=false \
	-Ddist_version=%version-%release

%meson_build -v

%install
%meson_install
%find_lang %name
mkdir -p %buildroot%_bindir
mkdir -p %buildroot%_sysconfdir/NetworkManager/VPN
mkdir -p %buildroot%_sysconfdir/NetworkManager/system-connections
mkdir -p %buildroot%_sysconfdir/NetworkManager/conf.d
mkdir -p %buildroot%nmlibdir/conf.d
mkdir -p %buildroot/%_var/log/
touch %buildroot/%_var/log/NetworkManager
mkdir -p %buildroot/%_var/lib/NetworkManager
touch %buildroot/%_var/lib/NetworkManager/timestamps
touch %buildroot/%_var/lib/NetworkManager/NetworkManager.state
mkdir -p %buildroot%nmlibdir/VPN/
install -m 0644 %SOURCE1 %buildroot%_sysconfdir/NetworkManager/
install -m 0755 %SOURCE2 %buildroot%dispatcherdir/
install -m 0755 %SOURCE5 %buildroot%dispatcherdir/
install -m 0755 %SOURCE7 %buildroot%dispatcherdir/
install -m 0755 %SOURCE8 %buildroot%dispatcherdir/
install -Dm0644 %SOURCE6 %buildroot%_sysconfdir/sysconfig/%name

mkdir -p %buildroot%_sysconfdir/NetworkManager/dispatcher.d/pre-{up,down,no-wait}.d

# Create pre-down.d/pre-up.d directories and
# symlink scripts if needed
mkdir -p %buildroot%dispatcherdir/pre-{up,down}.d
ln -s ../80-etcnet-iface-scripts %buildroot%dispatcherdir/pre-up.d/80-etcnet-iface-scripts
ln -s ../80-etcnet-iface-scripts %buildroot%dispatcherdir/pre-down.d/80-etcnet-iface-scripts

# Install initscript
install -Dm0755 %SOURCE11 %buildroot%_initrddir/NetworkManager

# Install NetworkManager pre start script
install -Dm0755 %SOURCE9 %buildroot%_sbindir/NetworkManager-prestart

# Install functions file for nm-dispather scripts
install -Dm0644 %SOURCE10 %buildroot%_libexecdir/NetworkManager/nm-dispatcher-sh-functions

# Install example configs
mkdir -p %buildroot%_defaultdocdir/%name-%version/examples/conf.d/
cp -a examples/nm-conf.d/* %buildroot%_defaultdocdir/%name-%version/examples/conf.d/

# Use 31-mac-addr-change.conf
# See https://bugzilla.altlinux.org/32467
# https://bugzilla.gnome.org/show_bug.cgi?id=777523
mv %buildroot%_defaultdocdir/%name-%version/examples/conf.d/31-mac-addr-change.conf %buildroot%nmlibdir/conf.d/

# Install 00-server.conf
install -Dm0644 contrib/fedora/rpm/00-server.conf %buildroot%nmlibdir/conf.d/00-server.conf

%if_enabled ifcfg
install -Dm0644 %SOURCE12 %buildroot%_sysconfdir/NetworkManager/conf.d/40-ifcfg-rh-plugin.conf
%endif

%check
%meson_test

%pre daemon
# Workaround for upgrade
[ -d %_var/lib/NetworkManager/timestamps ] &&
rm -rf %_var/lib/NetworkManager/timestamps/ ||:

%post daemon
%post_service_posttrans_restart %name
if sd_booted; then
	%post_service_posttrans_restart %name-wait-online.service
	%post_service_posttrans_restart %name-dispatcher.service
	%post_service_posttrans_restart nm-priv-helper.service
fi

%preun daemon
#preun_service %name
if [ "$1" -eq 0 ]; then
	SYSTEMCTL=systemctl
	if sd_booted && "$SYSTEMCTL" --version >/dev/null 2>&1; then
		"$SYSTEMCTL" --no-reload -q disable %name.service %name-wait-online.service %name-dispatcher.service nm-priv-helper.service ||:
	else
		chkconfig --del NetworkManager ||:
	fi

    killall -TERM nm-system-settings >/dev/null 2>&1 ||:
fi

%triggerpostun daemon -- %name <= 0.9.8.2-alt3
SYSTEMCTL=systemctl
if sd_booted && "$SYSTEMCTL" -q is-enabled %name.service; then
	"$SYSTEMCTL" enable -q %name-dispatcher.service
fi

%if_enabled nmcloudsetup
%post cloud-setup
if sd_booted; then
%post_service nm-cloud-setup.service
%post_service nm-cloud-setup.timer
fi

%preun cloud-setup
if sd_booted; then
%preun_service nm-cloud-setup.service
%preun_service nm-cloud-setup.timer
fi
%endif

%files

%files -f %name.lang daemon
%doc COPYING NEWS AUTHORS README.md CONTRIBUTING.md
%_bindir/nm-online
%_bindir/nmcli
%_datadir/dbus-1/system-services/*.service
%doc %_man1dir/*.*
%doc %_man5dir/*.*
%doc %_man7dir/*.*
%doc %_man8dir/*.*
%if_enabled nmcloudsetup
%exclude %_man8dir/nm-cloud-setup.*
%endif
%doc %_defaultdocdir/%name-%version/
%dir %_libdir/NetworkManager/
%dir %nmlibdir/
%dir %nmlibdir/VPN/
%dir %nmplugindir/
%nmplugindir/libnm-settings-plugin-etcnet-alt.so
%_libexecdir/NetworkManager/nm-*
%if_enabled nmcloudsetup
%exclude %_libexecdir/NetworkManager/nm-cloud-setup
%endif
%_sbindir/*
%_datadir/dbus-1/system.d/*.conf
%config(noreplace) %_sysconfdir/NetworkManager/%name.conf
%_initrddir/NetworkManager
%dir %_sysconfdir/NetworkManager
%dir %_sysconfdir/NetworkManager/VPN
%dir %_sysconfdir/NetworkManager/system-connections
%dir %_sysconfdir/NetworkManager/conf.d
%dir %nmlibdir/conf.d/
%config %nmlibdir/conf.d/31-mac-addr-change.conf
%dir %_var/lib/NetworkManager
%_sysconfdir/NetworkManager/dispatcher.d/
%dispatcherdir/
%ghost %config(noreplace) %_var/log/NetworkManager
%ghost %config(noreplace) %_var/lib/NetworkManager/NetworkManager.state
%ghost %config(noreplace) %_var/lib/NetworkManager/timestamps
%_udev_rulesdir/*
%_datadir/polkit-1/actions/*.policy
%_datadir/bash-completion/completions/*
%config(noreplace) %_sysconfdir/sysconfig/%name
%{?_enable_systemd:%_unitdir/%name.service}
%{?_enable_systemd:%_unitdir/%name-wait-online.service}
%{?_enable_systemd:%_unitdir/%name-dispatcher.service}
%{?_enable_systemd:%_unitdir/nm-priv-helper.service}
%if_enabled nmcloudsetup
%exclude %dispatcherdir/90-nm-cloud-setup.sh
%exclude %dispatcherdir/no-wait.d/90-nm-cloud-setup.sh
%exclude %dispatcherdir/pre-up.d/90-nm-cloud-setup.sh
%endif
%_usr/lib/firewalld/zones/*.xml

%{?_enable_systemd:%exclude %_unitdir/NetworkManager-config-initrd.service}
%{?_enable_systemd:%exclude %_unitdir/NetworkManager-initrd.service}
%{?_enable_systemd:%exclude %_unitdir/NetworkManager-wait-online-initrd.service}

%if_enabled ovs
%{?_enable_systemd:%dir %_unitdir/NetworkManager.service.d/}
%endif

%exclude %_man1dir/nmtui*
%if_enabled ovs
%exclude %_man7dir/nm-openvswitch.*
%endif

%if_enabled ifcfg
%exclude %_datadir/dbus-1/system.d/nm-ifcfg-rh.conf
%exclude %_man5dir/nm-settings-ifcfg-rh.*
%endif

%files config-server
%config %nmlibdir/conf.d/00-server.conf

%files adsl
%nmplugindir/libnm-device-plugin-adsl.so

%files bluetooth
%nmplugindir/libnm-device-plugin-bluetooth.so

%if_enabled ovs
%files ovs
%_unitdir/NetworkManager.service.d/NetworkManager-ovs.conf
%nmplugindir/libnm-device-plugin-ovs.so
%_man7dir/nm-openvswitch.*
%endif

%if_enabled teamdctl
%files team
%nmplugindir/libnm-device-plugin-team.so
%endif

%files wifi
%nmplugindir/libnm-device-plugin-wifi.so

%files wwan
%nmplugindir/libnm-device-plugin-wwan.so
%nmplugindir/libnm-wwan.so

%if_enabled nmtui
%files tui
%_bindir/nmtui*
%_man1dir/nmtui*
%endif

%if_enabled nmcloudsetup
%files cloud-setup
%_libexecdir/NetworkManager/nm-cloud-setup
%{?_enable_systemd:%_unitdir/nm-cloud-setup.service}
%{?_enable_systemd:%_unitdir/nm-cloud-setup.timer}
%dispatcherdir/90-nm-cloud-setup.sh
%dispatcherdir/no-wait.d/90-nm-cloud-setup.sh
%dispatcherdir/pre-up.d/90-nm-cloud-setup.sh
%_man8dir/nm-cloud-setup.*
%endif

%if_enabled ifcfg
%files ifcfg-rh
%config %_sysconfdir/NetworkManager/conf.d/40-ifcfg-rh-plugin.conf
%_datadir/dbus-1/system.d/nm-ifcfg-rh.conf
%nmplugindir/libnm-settings-plugin-ifcfg-rh.so
%_man5dir/nm-settings-ifcfg-rh.*
%endif


%files ppp
%_libdir/pppd/%ppp_version/nm-pppd-plugin.so
%nmplugindir/libnm-ppp-plugin.so

%files -n libnm
%_libdir/libnm.so.*

%files -n libnm-devel
%_includedir/libnm
%_pkgconfigdir/libnm.pc
%_libdir/libnm.so
%{?_enable_vala:%_vapidir/libnm.*}
%_datadir/dbus-1/interfaces/*.xml

%files -n libnm-devel-doc
%doc %_datadir/gtk-doc/html/libnm
%doc %_datadir/gtk-doc/html/%name

%if_enabled introspection
%files -n libnm-gir
%_libdir/girepository-1.0/NM-1.0.typelib

%files -n libnm-gir-devel
%_datadir/gir-1.0/NM-1.0.gir
%endif

%changelog
